/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.mc.h2upgraderunner;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public final class MCH2UpgradeCLIClassLoader
extends ClassLoader {
    static final int EXPECTED_CLASSES_COUNT = 4633;
    static final int EXTRA_CLASSES_COUNT_ALLOWED = 1000;
    private static final int MAP_INITIAL_CAPACITY = (int)Math.ceil(5689.89898989899);
    private final Map<String, byte[]> map = new HashMap<String, byte[]>(MAP_INITIAL_CAPACITY);

    public MCH2UpgradeCLIClassLoader() throws IOException {
        try (ZipInputStream zIS = new ZipInputStream(new XorInputStream(Objects.requireNonNull(this.getClass().getResourceAsStream("/h2-upgrade-cli"))));){
            ZipEntry ze;
            while ((ze = zIS.getNextEntry()) != null) {
                if (ze.isDirectory()) continue;
                this.map.put(ze.getName(), zIS.readAllBytes());
            }
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String resourceName = name.replace('.', '/') + ".class";
        byte[] b = this.map.get(resourceName);
        if (b == null) {
            throw new ClassNotFoundException(name);
        }
        return this.defineClass(name, b, 0, b.length);
    }

    @Override
    protected URL findResource(String name) {
        byte[] b = this.map.get(name);
        if (b == null) {
            return null;
        }
        return this.newByteURL(name, b);
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        return this.map.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(name)).map(entry -> this.newByteURL((String)entry.getKey(), (byte[])entry.getValue())).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::enumeration));
    }

    private URL newByteURL(String name, final byte[] b) {
        try {
            return new URL("bytes", "h2-upgrade-cli", -1, name, new URLStreamHandler(){

                @Override
                protected URLConnection openConnection(URL url) throws IOException {
                    return new URLConnection(url){

                        @Override
                        public void connect() throws IOException {
                        }

                        @Override
                        public InputStream getInputStream() throws IOException {
                            return new ByteArrayInputStream(b);
                        }
                    };
                }
            });
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    int getMapSize() {
        return this.map.size();
    }

    private static final class XorInputStream
    extends InputStream {
        private static final byte BYTE_MASK = 42;
        private final InputStream inputStream;

        private XorInputStream(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        @Override
        public int read() throws IOException {
            return this.inputStream.read() ^ 0x2A;
        }
    }
}

