/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.utils;

import java.util.regex.Pattern;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;

public final class StringUtil {
    public static final String MASK_FOR_SENSITIVE_DATA = "****";
    private static final Pattern ALPHANUMERIC_WITH_DASH_AND_UNDERSCORE = Pattern.compile("[^a-zA-Z0-9_\\-]");

    private StringUtil() {
    }

    public static boolean isAlphanumericWithDashAndUnderscore(String s) {
        return !ALPHANUMERIC_WITH_DASH_AND_UNDERSCORE.matcher(s).find();
    }

    public static boolean isNullOrEmptyAfterTrim(String s) {
        return StringUtils.isBlank((CharSequence)s);
    }

    public static boolean containsTrailingOrLeadingWhitespace(String s) {
        return s != null && !s.trim().equals(s);
    }

    public static String unwrapDoubleQuotes(String s) {
        return StringUtils.unwrap((String)s, (char)'\"');
    }

    public static String wrapWithSingleQuotes(String s) {
        return StringUtils.wrap((String)s, (char)'\'');
    }

    public static String duplicateSingleQuotes(String s) {
        return RegExUtils.replaceAll((String)s, (String)"'", (String)"''");
    }
}

