/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.telemetry;

import com.hazelcast.webmonitor.model.telemetry.PhoneHomeData;
import com.hazelcast.webmonitor.security.spi.impl.SecurityProviderEventListener;
import com.hazelcast.webmonitor.service.dynamicconfig.ConfigUpdateTriggeredEvent;
import com.hazelcast.webmonitor.service.healthcheck.HealthCheckListener;
import com.hazelcast.webmonitor.service.telemetry.DataCollector;
import com.hazelcast.webmonitor.sql.QueryHistoryRecord;
import com.hazelcast.webmonitor.sql.SqlExecutedEvent;
import com.hazelcast.webmonitor.sql.SqlUsage;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.EventListener;

@ThreadSafe
public class FeatureUsageTracker
implements DataCollector,
HealthCheckListener,
ApplicationListener<SqlExecutedEvent>,
SecurityProviderEventListener {
    @GuardedBy(value="this")
    private int healthCheckExecutionCount;
    @GuardedBy(value="this")
    private int healthCheckTotalProblemCount;
    @GuardedBy(value="this")
    private int healthCheckIgnoredProblemCount;
    @GuardedBy(value="this")
    private int healthCheckSettingsResetCount;
    @GuardedBy(value="this")
    private int sqlSuccesses;
    @GuardedBy(value="this")
    private int sqlStreamingSuccesses;
    @GuardedBy(value="this")
    private int sqlFailures;
    @GuardedBy(value="this")
    private int securityProviderSetCount;
    @GuardedBy(value="this")
    private int consoleSuccesses;
    @GuardedBy(value="this")
    private int consoleFailures;
    @GuardedBy(value="this")
    private int dynamicConfigUpdateCount;

    public synchronized void healthCheckRan(int problemsFound) {
        ++this.healthCheckExecutionCount;
        this.healthCheckTotalProblemCount += problemsFound;
    }

    public synchronized void healthCheckIgnoreListEntryAdded() {
        ++this.healthCheckIgnoredProblemCount;
    }

    public synchronized void healthCheckSettingsReset() {
        ++this.healthCheckSettingsResetCount;
    }

    public synchronized void collectInto(PhoneHomeData data) {
        data.setHealthCheckExecutionCount(this.healthCheckExecutionCount);
        data.setHealthCheckTotalProblemCount(this.healthCheckTotalProblemCount);
        data.setHealthCheckIgnoredProblemCount(this.healthCheckIgnoredProblemCount);
        data.setHealthCheckSettingsResetCount(this.healthCheckSettingsResetCount);
        data.setSqlSuccessCount(this.sqlSuccesses);
        data.setSqlSuccessStreamingCount(this.sqlStreamingSuccesses);
        data.setSqlFailureCount(this.sqlFailures);
        data.setSecurityProviderSetCount(this.securityProviderSetCount);
        data.setConsoleSuccessCount(this.consoleSuccesses);
        data.setConsoleFailureCount(this.consoleFailures);
        data.setDynamicConfigurationUpdateCount(this.dynamicConfigUpdateCount);
        this.dynamicConfigUpdateCount = 0;
        this.healthCheckTotalProblemCount = 0;
        this.healthCheckExecutionCount = 0;
        this.healthCheckIgnoredProblemCount = 0;
        this.healthCheckSettingsResetCount = 0;
        this.sqlSuccesses = 0;
        this.sqlStreamingSuccesses = 0;
        this.sqlFailures = 0;
        this.securityProviderSetCount = 0;
        this.consoleSuccesses = 0;
        this.consoleFailures = 0;
    }

    public synchronized void onApplicationEvent(SqlExecutedEvent event) {
        SqlUsage sqlUsage = event.getSqlUsage();
        if (sqlUsage.getStatus() == QueryHistoryRecord.Status.SUCCESS) {
            ++this.sqlSuccesses;
            if (sqlUsage.isStreamingQuery()) {
                ++this.sqlStreamingSuccesses;
            }
        } else {
            ++this.sqlFailures;
        }
    }

    public synchronized void securityProviderSet() {
        ++this.securityProviderSetCount;
    }

    @EventListener
    public synchronized void dynamicConfigUpdateProcessTriggered(ConfigUpdateTriggeredEvent event) {
        ++this.dynamicConfigUpdateCount;
    }
}

