/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.jmx.impl;

import com.hazelcast.webmonitor.controller.dto.clustered.WanRepStatsDTO;
import com.hazelcast.webmonitor.model.AllState;
import com.hazelcast.webmonitor.service.ClusteredStatsService;
import com.hazelcast.webmonitor.service.jmx.BaseManagementBean;
import com.hazelcast.webmonitor.service.jmx.WanRepMXBean;
import com.hazelcast.webmonitor.service.jmx.impl.MXBeanHelper;
import javax.management.ObjectName;

public class WanRepMXBeanImpl
implements WanRepMXBean,
BaseManagementBean {
    public static final String TYPE_NAME = "WanConfigs";
    private final ClusteredStatsService statsService;
    private final String cluster;
    private final String configName;
    private final String publisherId;
    private volatile WanRepStatsDTO stats;

    public WanRepMXBeanImpl(ClusteredStatsService statsService, String cluster, String wanConfigName, String publisherId) {
        this.statsService = statsService;
        this.cluster = cluster;
        this.configName = wanConfigName;
        this.publisherId = publisherId;
    }

    public String getName() {
        return this.configName + "[" + this.publisherId + "]";
    }

    public String getCluster() {
        return this.cluster;
    }

    public String getConfigName() {
        return this.configName;
    }

    public String getPublisherId() {
        return this.publisherId;
    }

    public void updateFrom(AllState state) {
        if (state == null) {
            return;
        }
        this.stats = this.statsService.getWanRepStats(this.cluster, this.configName, this.publisherId);
    }

    public long getTotalPublishedEventCount() {
        return MXBeanHelper.safeGet((Object)this.stats, WanRepStatsDTO::getTotalPublishedEventCount);
    }

    public long getTotalPublishLatency() {
        return MXBeanHelper.safeGet((Object)this.stats, WanRepStatsDTO::getTotalPublishLatency);
    }

    public int getOutboundQueueSize() {
        return MXBeanHelper.safeGet((Object)this.stats, WanRepStatsDTO::getOutboundQueueSize);
    }

    public ObjectName getObjectName() {
        return BaseManagementBean.getObjectName((String)this.getCluster(), (String)TYPE_NAME, (String)this.getName());
    }
}

