/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.jmx.impl;

import com.hazelcast.webmonitor.controller.dto.clustered.QueueStatsDTO;
import com.hazelcast.webmonitor.model.AllState;
import com.hazelcast.webmonitor.service.ClusteredStatsService;
import com.hazelcast.webmonitor.service.jmx.BaseManagementBean;
import com.hazelcast.webmonitor.service.jmx.QueueMXBean;
import com.hazelcast.webmonitor.service.jmx.impl.MXBeanHelper;
import javax.management.ObjectName;

public class QueueMXBeanImpl
implements QueueMXBean,
BaseManagementBean {
    public static final String TYPE_NAME = "Queues";
    private final ClusteredStatsService statsService;
    private final String cluster;
    private final String name;
    private volatile QueueStatsDTO stats;

    public QueueMXBeanImpl(ClusteredStatsService statsService, String cluster, String name) {
        this.statsService = statsService;
        this.cluster = cluster;
        this.name = name;
    }

    public void updateFrom(AllState state) {
        if (state == null) {
            return;
        }
        this.stats = this.statsService.getQueueStats(this.cluster, this.name);
    }

    public String getName() {
        return this.name;
    }

    public String getCluster() {
        return this.cluster;
    }

    public long getCreationTime() {
        return MXBeanHelper.safeGet((Object)this.stats, QueueStatsDTO::getCreationTime);
    }

    public long getOwnedItemCount() {
        return MXBeanHelper.safeGet((Object)this.stats, QueueStatsDTO::getOwnedItemCount);
    }

    public long getBackupItemCount() {
        return MXBeanHelper.safeGet((Object)this.stats, QueueStatsDTO::getBackupItemCount);
    }

    public long getMinAge() {
        return MXBeanHelper.safeGet((Object)this.stats, QueueStatsDTO::getMinAge, (long)Long.MAX_VALUE);
    }

    public long getMaxAge() {
        return MXBeanHelper.safeGet((Object)this.stats, QueueStatsDTO::getMaxAge, (long)Long.MIN_VALUE);
    }

    public long getAverageAge() {
        return MXBeanHelper.safeGet((Object)this.stats, QueueStatsDTO::getAverageAge);
    }

    public long getOfferOperationCount() {
        return MXBeanHelper.safeGet((Object)this.stats, QueueStatsDTO::getOfferOperationCount);
    }

    public long getRejectedOffers() {
        return MXBeanHelper.safeGet((Object)this.stats, QueueStatsDTO::getRejectedOffers);
    }

    public long getPollOperationCount() {
        return MXBeanHelper.safeGet((Object)this.stats, QueueStatsDTO::getPollOperationCount);
    }

    public long getEmptyPolls() {
        return MXBeanHelper.safeGet((Object)this.stats, QueueStatsDTO::getEmptyPolls);
    }

    public long getOtherOperationsCount() {
        return MXBeanHelper.safeGet((Object)this.stats, QueueStatsDTO::getOtherOperationCount);
    }

    public long getEvents() {
        return MXBeanHelper.safeGet((Object)this.stats, QueueStatsDTO::getEvents);
    }

    public ObjectName getObjectName() {
        return BaseManagementBean.getObjectName((String)this.getCluster(), (String)TYPE_NAME, (String)this.getName());
    }
}

