/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.jmx.impl;

import com.hazelcast.webmonitor.controller.dto.clustered.PNCounterStatsDTO;
import com.hazelcast.webmonitor.model.AllState;
import com.hazelcast.webmonitor.service.ClusteredStatsService;
import com.hazelcast.webmonitor.service.jmx.BaseManagementBean;
import com.hazelcast.webmonitor.service.jmx.PNCounterMXBean;
import com.hazelcast.webmonitor.service.jmx.impl.MXBeanHelper;
import java.util.Collections;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.management.ObjectName;

public class PNCounterMXBeanImpl
implements PNCounterMXBean,
BaseManagementBean {
    public static final String TYPE_NAME = "Counters";
    private final ClusteredStatsService statsService;
    private final String cluster;
    private final String name;
    private volatile PNCounterStatsDTO stats;

    public PNCounterMXBeanImpl(ClusteredStatsService statsService, String cluster, String name) {
        this.statsService = statsService;
        this.cluster = cluster;
        this.name = name;
    }

    public ObjectName getObjectName() {
        return BaseManagementBean.getObjectName((String)this.cluster, (String)TYPE_NAME, (String)this.name);
    }

    public void updateFrom(AllState state) {
        if (state == null) {
            return;
        }
        this.stats = this.statsService.getPNCounterStats(this.cluster, this.name);
    }

    public long getCreationTime() {
        return MXBeanHelper.safeGet((Object)this.stats, PNCounterStatsDTO::getCreationTime);
    }

    public String getName() {
        return this.name;
    }

    public String getCluster() {
        return this.cluster;
    }

    public SortedMap<String, PNCounterMXBean.PNCounterMemberStats> getStatsPerMember() {
        return this.stats != null ? new TreeMap(this.stats.getStatsPerMember()) : Collections.emptySortedMap();
    }
}

