/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.jmx.impl;

import com.hazelcast.webmonitor.controller.dto.clustered.ManagedExecutorStatsDTO;
import com.hazelcast.webmonitor.model.AllState;
import com.hazelcast.webmonitor.service.ClusteredStatsService;
import com.hazelcast.webmonitor.service.jmx.BaseManagementBean;
import com.hazelcast.webmonitor.service.jmx.ManagedExecutorMXBean;
import com.hazelcast.webmonitor.service.jmx.impl.MXBeanHelper;
import javax.management.ObjectName;

public class ManagedExecutorMXBeanImpl
implements ManagedExecutorMXBean,
BaseManagementBean {
    public static final String TYPE_NAME = "Services";
    public static final String SERVICE_NAME = "ManagedExecutor";
    private final ClusteredStatsService statsService;
    private final String cluster;
    private final String member;
    private final String name;
    private volatile ManagedExecutorStatsDTO stats;

    public ManagedExecutorMXBeanImpl(ClusteredStatsService statsService, String cluster, String member, String name) {
        this.statsService = statsService;
        this.cluster = cluster;
        this.member = member;
        this.name = name;
    }

    public void updateFrom(AllState state) {
        if (state == null) {
            return;
        }
        this.stats = this.statsService.getManagedExecutorStats(this.cluster, this.member, this.name);
    }

    public String getName() {
        return this.member + "###" + this.name;
    }

    public int getQueueSize() {
        return MXBeanHelper.safeGet((Object)this.stats, ManagedExecutorStatsDTO::getQueueSize);
    }

    public int getPoolSize() {
        return MXBeanHelper.safeGet((Object)this.stats, ManagedExecutorStatsDTO::getPoolSize);
    }

    public int getRemainingQueueCapacity() {
        return MXBeanHelper.safeGet((Object)this.stats, ManagedExecutorStatsDTO::getRemainingQueueCapacity);
    }

    public int getMaximumPoolSize() {
        return MXBeanHelper.safeGet((Object)this.stats, ManagedExecutorStatsDTO::getMaximumPoolSize);
    }

    public long getCompletedTaskCount() {
        return MXBeanHelper.safeGet((Object)this.stats, ManagedExecutorStatsDTO::getCompletedTaskCount);
    }

    public ObjectName getObjectName() {
        return BaseManagementBean.getObjectName((String)this.cluster, (String)TYPE_NAME, (String)("ManagedExecutor[" + this.name + "]"), (String)this.member);
    }
}

