/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.jmx.impl;

import com.hazelcast.webmonitor.model.AllState;
import com.hazelcast.webmonitor.model.hz.req.state.ClientEndPointDTO;
import com.hazelcast.webmonitor.service.jmx.BaseManagementBean;
import com.hazelcast.webmonitor.service.jmx.ClientMXBean;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.management.ObjectName;

public class ClientMXBeanImpl
implements ClientMXBean,
BaseManagementBean {
    public static final String TYPE_NAME = "Clients";
    private final String cluster;
    private final String name;
    private final String address;
    private volatile String ipAddress;
    private volatile String canonicalHostName;
    private volatile String clientName;
    private volatile String uuid;
    private volatile String clientType;
    private volatile Set<String> labels = Collections.emptySet();

    public ClientMXBeanImpl(String cluster, String address) {
        this.cluster = cluster;
        this.name = address;
        this.address = address;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getAddress() {
        return this.address;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getCanonicalHostName() {
        return this.canonicalHostName;
    }

    public String getClientType() {
        return this.clientType;
    }

    public String getClientName() {
        return this.clientName;
    }

    public Set<String> getLabels() {
        return this.labels;
    }

    public String getName() {
        return this.name;
    }

    public void updateFrom(AllState allState) {
        if (allState == null) {
            return;
        }
        Map clients = allState.getClients();
        ClientEndPointDTO client = (ClientEndPointDTO)clients.get(this.address);
        if (client != null) {
            this.clientName = client.getName();
            this.uuid = client.getUuid();
            this.ipAddress = client.getIpAddress();
            this.canonicalHostName = client.getCanonicalHostName();
            this.clientType = client.getClientType();
            this.labels = new TreeSet();
            if (client.getLabels() != null) {
                this.labels.addAll(client.getLabels());
            }
        }
    }

    public ObjectName getObjectName() {
        return BaseManagementBean.getObjectName((String)this.cluster, (String)TYPE_NAME, (String)this.name);
    }
}

