/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.jmx.impl;

import com.hazelcast.webmonitor.controller.dto.clustered.CacheStatsDTO;
import com.hazelcast.webmonitor.model.AllState;
import com.hazelcast.webmonitor.service.ClusteredStatsService;
import com.hazelcast.webmonitor.service.jmx.BaseManagementBean;
import com.hazelcast.webmonitor.service.jmx.CacheMXBean;
import com.hazelcast.webmonitor.service.jmx.impl.MXBeanHelper;
import javax.management.ObjectName;

public class CacheMXBeanImpl
implements CacheMXBean,
BaseManagementBean {
    public static final String TYPE_NAME = "Caches";
    private final ClusteredStatsService statsService;
    private final String cluster;
    private final String name;
    private volatile CacheStatsDTO stats;

    public CacheMXBeanImpl(ClusteredStatsService statsService, String cluster, String name) {
        this.statsService = statsService;
        this.cluster = cluster;
        this.name = name;
    }

    public void updateFrom(AllState state) {
        if (state == null) {
            return;
        }
        this.stats = this.statsService.getCacheStats(this.cluster, this.name);
    }

    public String getCluster() {
        return this.cluster;
    }

    public long getHits() {
        return MXBeanHelper.safeGet((Object)this.stats, CacheStatsDTO::getHits);
    }

    public long getMisses() {
        return MXBeanHelper.safeGet((Object)this.stats, CacheStatsDTO::getMisses);
    }

    public long getGetOperationCount() {
        return MXBeanHelper.safeGet((Object)this.stats, CacheStatsDTO::getGetOperationCount);
    }

    public long getPutOperationCount() {
        return MXBeanHelper.safeGet((Object)this.stats, CacheStatsDTO::getPutOperationCount);
    }

    public long getRemoveOperationCount() {
        return MXBeanHelper.safeGet((Object)this.stats, CacheStatsDTO::getRemoveOperationCount);
    }

    public long getEvictions() {
        return MXBeanHelper.safeGet((Object)this.stats, CacheStatsDTO::getEvictions);
    }

    public float getAverageGetTime() {
        return MXBeanHelper.safeGet((Object)this.stats, CacheStatsDTO::getAverageGetTime);
    }

    public float getAveragePutTime() {
        return MXBeanHelper.safeGet((Object)this.stats, CacheStatsDTO::getAveragePutTime);
    }

    public float getAverageRemoveTime() {
        return MXBeanHelper.safeGet((Object)this.stats, CacheStatsDTO::getAverageRemoveTime);
    }

    public long getLastAccessTime() {
        return MXBeanHelper.safeGet((Object)this.stats, CacheStatsDTO::getLastAccessTime);
    }

    public long getLastUpdateTime() {
        return MXBeanHelper.safeGet((Object)this.stats, CacheStatsDTO::getLastUpdateTime);
    }

    public long getOwnedEntryCount() {
        return MXBeanHelper.safeGet((Object)this.stats, CacheStatsDTO::getOwnedEntryCount);
    }

    public String getName() {
        return this.name;
    }

    public ObjectName getObjectName() {
        return BaseManagementBean.getObjectName((String)this.getCluster(), (String)TYPE_NAME, (String)this.getName());
    }
}

