/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.webmonitor.security.spi.impl.AuthenticationManagerImpl;
import com.hazelcast.webmonitor.service.CPStatsRegistry;
import com.hazelcast.webmonitor.service.CPSubsystemManager;
import com.hazelcast.webmonitor.service.ClusterManager;
import com.hazelcast.webmonitor.service.MemberManager;
import com.hazelcast.webmonitor.service.StateManager;
import com.hazelcast.webmonitor.service.healthcheck.Analyzer;
import com.hazelcast.webmonitor.service.healthcheck.AnalyzerCheckId;
import com.hazelcast.webmonitor.service.healthcheck.CPMapSoftLimitAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.CPSubsystemStatusAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.ClientCountAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.ClusterSizeAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.ConditionalOnCheckId;
import com.hazelcast.webmonitor.service.healthcheck.DeviceUsageAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.MemberMachinesAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.NativeMemorySizeAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataSubscriptionPool;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
public class UsageAnalyzerConfig {
    @Bean
    @ConditionalOnCheckId(value=AnalyzerCheckId.DEVICE_USAGE_ANALYZER)
    Analyzer deviceUsageAnalyzer(SourceDataSubscriptionPool pool) {
        return new DeviceUsageAnalyzer(pool);
    }

    @Bean
    @ConditionalOnCheckId(value=AnalyzerCheckId.NATIVE_MEMORY_SIZE_ANALYZER)
    Analyzer nativeMemorySizeAnalyzer(SourceDataSubscriptionPool pool, ClusterManager clusterManager, StateManager stateManager) {
        return new NativeMemorySizeAnalyzer(pool, clusterManager, stateManager);
    }

    @Bean
    @ConditionalOnCheckId(value=AnalyzerCheckId.CLIENT_COUNT_ANALYZER)
    Analyzer clientCountAnalyzer(StateManager stateManager) {
        return new ClientCountAnalyzer(stateManager);
    }

    @Bean
    @ConditionalOnCheckId(value=AnalyzerCheckId.CP_MAP_SOFT_LIMIT_ANALYZER)
    Analyzer cpMapSoftLimitAnalyzer(SourceDataSubscriptionPool pool, CPStatsRegistry cpStatsRegistry) {
        return new CPMapSoftLimitAnalyzer(pool, cpStatsRegistry);
    }

    @Profile(value={"!hzcloud"})
    @Bean
    @ConditionalOnCheckId(value=AnalyzerCheckId.CP_SUBSYSTEM_STATUS_ANALYZER)
    Analyzer cpSubsystemStatusAnalyzer(CPSubsystemManager manager, StateManager stateManager) {
        return new CPSubsystemStatusAnalyzer(manager, stateManager);
    }

    @Profile(value={"!hzcloud"})
    @Bean
    @ConditionalOnCheckId(value=AnalyzerCheckId.CLUSTER_SIZE_ANALYZER)
    Analyzer clusterSizeAnalyzer(AuthenticationManagerImpl authenticationManager, ClusterManager clusterManager, MemberManager memberManager) {
        return new ClusterSizeAnalyzer(authenticationManager, clusterManager, memberManager);
    }

    @Profile(value={"!hzcloud"})
    @Bean
    @ConditionalOnCheckId(value=AnalyzerCheckId.MEMBER_MACHINES_ANALYZER)
    MemberMachinesAnalyzer memberMachinesAnalyzer(MemberManager memberManager) {
        return new MemberMachinesAnalyzer(memberManager);
    }
}

