/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.google.common.annotations.VisibleForTesting;
import com.hazelcast.config.ConfigStream;
import com.hazelcast.internal.config.MemberXmlConfigRootTagRecognizer;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.healthcheck.AnalysisOutcome;
import com.hazelcast.webmonitor.service.healthcheck.Analyzer;
import com.hazelcast.webmonitor.service.healthcheck.AnalyzerCheckId;
import com.hazelcast.webmonitor.service.healthcheck.IgnoreList;
import com.hazelcast.webmonitor.service.healthcheck.MemberProblem;
import com.hazelcast.webmonitor.service.healthcheck.MinRequiredVersion;
import com.hazelcast.webmonitor.service.healthcheck.Problem;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataFilter;
import com.hazelcast.webmonitor.service.healthcheck.VersionRestriction;
import com.hazelcast.webmonitor.service.memberconfig.MemberConfigService;
import com.hazelcast.webmonitor.utils.XmlUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * Exception performing whole class analysis ignored.
 */
@MinRequiredVersion(value="5.5.2", type=VersionRestriction.VersionCheckType.MEMBERS)
class MemberConfigFileAnalyzer
extends Analyzer {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MemberConfigFileAnalyzer.class);
    private final MemberConfigService memberConfigService;
    private final MemberXmlConfigRootTagRecognizer memberXmlConfigRootTagRecognizer;

    MemberConfigFileAnalyzer(MemberConfigService memberConfigService) throws Exception {
        this.memberConfigService = memberConfigService;
        this.memberXmlConfigRootTagRecognizer = new MemberXmlConfigRootTagRecognizer();
    }

    AnalysisOutcome doAnalyze(SourceDataFilter filter, IgnoreList ignoreList) {
        String cluster = filter.getCluster();
        ArrayList problems = new ArrayList();
        HashMap<String, Integer> dataStructureConfigCounts = new HashMap<String, Integer>();
        XPath xPath = XPathFactory.newInstance().newXPath();
        Map dataStructureConfigXPaths = Map.ofEntries(Map.entry("map", xPath.compile("hazelcast/map")), Map.entry("replicated map", xPath.compile("hazelcast/replicatedmap")), Map.entry("cache", xPath.compile("hazelcast/cache")), Map.entry("multimap", xPath.compile("hazelcast/multimap")), Map.entry("list", xPath.compile("hazelcast/list")), Map.entry("set", xPath.compile("hazelcast/set")), Map.entry("vector collection", xPath.compile("hazelcast/vector-collection")), Map.entry("PN counter", xPath.compile("hazelcast/pn-counter")), Map.entry("flake ID generator", xPath.compile("hazelcast/flake-id-generator")), Map.entry("queue", xPath.compile("hazelcast/queue")), Map.entry("topic", xPath.compile("hazelcast/topic")), Map.entry("CPMap", xPath.compile("hazelcast/cp-subsystem/maps/map/name")), Map.entry("fenced lock", xPath.compile("hazelcast/cp-subsystem/locks/fenced-lock/name")), Map.entry("semaphore", xPath.compile("hazelcast/cp-subsystem/semaphores/semaphore/name")));
        for (Map.Entry configEntry : this.memberConfigService.getConfigFileContents(cluster).entrySet()) {
            String memberAddress = (String)configEntry.getKey();
            String contents = (String)configEntry.getValue();
            try {
                boolean isXML = this.checkIfConfigIsXML(contents);
                if (!isXML) continue;
                Document document = XmlUtil.getDocumentFromXmlString((String)contents);
                for (Map.Entry dataStructure : dataStructureConfigXPaths.entrySet()) {
                    NodeList nodes = (NodeList)((XPathExpression)dataStructure.getValue()).evaluate(document, XPathConstants.NODESET);
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        Node node = nodes.item(i);
                        String name = MemberConfigFileAnalyzer.getNameFromNode((Node)node);
                        dataStructureConfigCounts.merge(name, 1, Integer::sum);
                    }
                    MemberConfigFileAnalyzer.addProblems(dataStructureConfigCounts, problems, (String)cluster, (String)memberAddress, (String)((String)dataStructure.getKey()));
                    dataStructureConfigCounts.clear();
                }
            }
            catch (Exception e) {
                log.warn("Error while analyzing configuration file for member {}", (Object)memberAddress, (Object)e);
            }
        }
        return AnalysisOutcome.withProblems((String)this.getCheckId(), (String)this.describeSelf(), problems);
    }

    private boolean checkIfConfigIsXML(String contents) throws Exception {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(contents.getBytes(StandardCharsets.UTF_8));){
            boolean bl;
            try (ConfigStream configStream = new ConfigStream((InputStream)inputStream);){
                bl = this.memberXmlConfigRootTagRecognizer.isRecognized(configStream);
            }
            return bl;
        }
    }

    private static void addProblems(Map<String, Integer> configCounts, List<Problem> problems, String cluster, String address, String dataStructure) {
        MemberIdentifier memberIdentifier = MemberIdentifier.of((String)cluster, (String)address);
        for (Map.Entry<String, Integer> entry : configCounts.entrySet()) {
            if (entry.getValue() <= 1) continue;
            problems.add((Problem)new MemberProblem(String.format("Duplicate configuration found for %s %s in the member configuration file", dataStructure, entry.getKey()), "Make sure there is only one configuration for the same data structure to prevent overwriting", Problem.ProblemType.WARNING, memberIdentifier));
        }
    }

    @VisibleForTesting
    static String getNameFromNode(Node node) {
        if ("name".equals(node.getNodeName())) {
            return node.getTextContent();
        }
        return node.getAttributes().getNamedItem("name").getNodeValue();
    }

    String getCheckId() {
        return AnalyzerCheckId.MEMBER_CONFIG_FILE_ANALYZER.getCheckId();
    }

    String describeSelf() {
        return "Checking if configuration files contain duplicate configurations for data structures";
    }
}

