/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.config.MapConfig;
import com.hazelcast.webmonitor.service.healthcheck.AnalyzerCheckId;
import com.hazelcast.webmonitor.service.healthcheck.ClusterWideProblem;
import com.hazelcast.webmonitor.service.healthcheck.Problem;
import com.hazelcast.webmonitor.service.healthcheck.SemanticConfigAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataSubscriptionPool;
import com.hazelcast.webmonitor.service.memberconfig.MemberConfig;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class MapQueryCacheConsistencyAnalyzer
extends SemanticConfigAnalyzer {
    MapQueryCacheConsistencyAnalyzer(SourceDataSubscriptionPool pool) {
        super(pool);
    }

    protected List<Problem> doAnalyzeInternal(MemberConfig config, List<String> disabledDataStructures) {
        return config.toEffectiveConfig().getMapConfigs().values().stream().filter(mapConfig -> !disabledDataStructures.contains(mapConfig.getName())).flatMap(MapQueryCacheConsistencyAnalyzer::identifyProblems).collect(Collectors.toList());
    }

    private static Stream<Problem> identifyProblems(MapConfig mapConfig) {
        return mapConfig.getQueryCacheConfigs().stream().filter(queryCache -> queryCache.getDelaySeconds() == 0).filter(queryCache -> queryCache.getBatchSize() > 1).map(queryCache -> new ClusterWideProblem(String.format("Query cache %s of map config %s uses batch updates while delay-seconds is 0", queryCache.getName(), mapConfig.getName()), "Either set a positive delay-seconds value or set batch-size to 1", Problem.ProblemType.FAIL, mapConfig.getName()));
    }

    public String describeSelf() {
        return "Checking if Map query caches configured with batch updates have higher than 0 delay-seconds";
    }

    String getCheckId() {
        return AnalyzerCheckId.MAP_QUERY_CACHE_CONSISTENCY_ANALYZER.getCheckId();
    }
}

