/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.MapConfig;
import com.hazelcast.webmonitor.service.healthcheck.AnalyzerCheckId;
import com.hazelcast.webmonitor.service.healthcheck.ClusterWideProblem;
import com.hazelcast.webmonitor.service.healthcheck.Problem;
import com.hazelcast.webmonitor.service.healthcheck.SemanticConfigAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataSubscriptionPool;
import com.hazelcast.webmonitor.service.memberconfig.MemberConfig;
import java.util.List;
import java.util.stream.Collectors;

class MapEvictionConfigAnalyzer
extends SemanticConfigAnalyzer {
    MapEvictionConfigAnalyzer(SourceDataSubscriptionPool pool) {
        super(pool);
    }

    String getCheckId() {
        return AnalyzerCheckId.MAP_EVICTION_CONFIG_ANALYZER.getCheckId();
    }

    String describeSelf() {
        return "Checking if eviction policy and size is configured properly for maps";
    }

    List<Problem> doAnalyzeInternal(MemberConfig config, List<String> disabledDataStructures) {
        return config.toEffectiveConfig().getMapConfigs().values().stream().filter(mapConfig -> !disabledDataStructures.contains(mapConfig.getName())).filter(MapEvictionConfigAnalyzer::hasNoEvictionPolicyButHasSize).map(MapEvictionConfigAnalyzer::toProblem).collect(Collectors.toUnmodifiableList());
    }

    private static boolean hasNoEvictionPolicyButHasSize(MapConfig mapConfig) {
        EvictionConfig evictionConfig = mapConfig.getEvictionConfig();
        return evictionConfig.getEvictionPolicy() == EvictionPolicy.NONE && evictionConfig.getSize() != Integer.MAX_VALUE;
    }

    private static ClusterWideProblem toProblem(MapConfig mapConfig) {
        String mapName = mapConfig.getName();
        return new ClusterWideProblem(String.format("Eviction size is set as %d for map config %s but eviction policy is NONE.", mapConfig.getEvictionConfig().getSize(), mapName), String.format("Configure an eviction policy other than NONE or set eviction size to zero for map config %s.", mapName), Problem.ProblemType.WARNING, mapName);
    }
}

