/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.config.DeviceConfig;
import com.hazelcast.webmonitor.metrics.Metric;
import com.hazelcast.webmonitor.metrics.MetricDataPoint;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.healthcheck.AbstractDeviceAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.AnalyzerCheckId;
import com.hazelcast.webmonitor.service.healthcheck.MemberProblem;
import com.hazelcast.webmonitor.service.healthcheck.PercentageUtils;
import com.hazelcast.webmonitor.service.healthcheck.Problem;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataSubscriptionPool;
import com.hazelcast.webmonitor.service.healthcheck.StorageSizeFormatter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
class DeviceCapacityAnalyzer
extends AbstractDeviceAnalyzer {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeviceCapacityAnalyzer.class);
    public static final String DEVICE_CAPACITY_ANALYZER_DESCRIPTION = "Tiered Storage: checking if member device capacities are valid";
    public static final String DEVICE_CAPACITY_ANALYZER_ADVICE = "Please set your device capacity configuration to a smaller value";

    DeviceCapacityAnalyzer(SourceDataSubscriptionPool poolDelegate) {
        super(poolDelegate);
    }

    String getMetricName() {
        return Metric.TIERED_STORE_PHYSICAL_DEVICE_CAPACITY.getName();
    }

    protected Optional<MemberProblem> getMemberProblem(MemberIdentifier memberIdentifier, String deviceName, DeviceConfig deviceConfig, MetricDataPoint metricDataPoint) {
        long deviceConfigCapacity = deviceConfig.getCapacity().bytes();
        long physicalDeviceCapacity = metricDataPoint.getValue();
        log.trace("Member {} device {} has device config vs actual capacity {}<>{}", new Object[]{memberIdentifier, deviceName, deviceConfigCapacity, physicalDeviceCapacity});
        if (deviceConfigCapacity > physicalDeviceCapacity) {
            String baseDirPath = DeviceCapacityAnalyzer.getDeviceBaseDirOrNull((DeviceConfig)deviceConfig);
            MemberProblem problem = DeviceCapacityAnalyzer.deviceCapacityMemberProblem((MemberIdentifier)memberIdentifier, (long)deviceConfigCapacity, (long)physicalDeviceCapacity, (String)deviceName, (String)baseDirPath);
            log.debug(problem.getDescription());
            return Optional.of(problem);
        }
        return Optional.empty();
    }

    public String describeSelf() {
        return "Tiered Storage: checking if member device capacities are valid";
    }

    String getCheckId() {
        return AnalyzerCheckId.DEVICE_CAPACITY_ANALYZER.getCheckId();
    }

    public static MemberProblem deviceCapacityMemberProblem(MemberIdentifier memberIdentifier, long deviceConfigCapacity, long deviceCapacity, String deviceName, String baseDirPath) {
        StorageSizeFormatter storageSizeFormatter = new StorageSizeFormatter(deviceCapacity, deviceConfigCapacity);
        Object description = String.format("Tiered Storage: the configured device capacity of %s is greater than the actual device capacity of %s (over by %,.2f%%) for device %s on member %s", storageSizeFormatter.getConfiguredStorage(), storageSizeFormatter.getUsedStorage(), PercentageUtils.calculateExcessInPercentage((long)deviceConfigCapacity, (long)deviceCapacity), deviceName, memberIdentifier.getMemberAddress());
        if (baseDirPath != null) {
            description = (String)description + " at base directory " + baseDirPath;
        }
        return new MemberProblem((String)description, "Please set your device capacity configuration to a smaller value", Problem.ProblemType.WARNING, memberIdentifier);
    }
}

