/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.client_filtering;

import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.webmonitor.service.ClusterClientFilteringDTO;
import com.hazelcast.webmonitor.service.ConnectedToClusterEvent;
import com.hazelcast.webmonitor.service.client_filtering.ClientFilteringService;
import com.hazelcast.webmonitor.service.client_filtering.ClientFilteringSharedSource;
import com.hazelcast.webmonitor.service.client_filtering.ClusterLockManager;
import com.hazelcast.webmonitor.service.client_filtering.LoggingReadWriteLock;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;

public class ClientFilteringPublisher {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClientFilteringPublisher.class);
    private final ClientFilteringService clientFilteringService;
    private final ClientFilteringSharedSource clientFilteringSharedSource;
    private final ClusterLockManager clusterLockManager;

    public ClientFilteringPublisher(ClientFilteringService clientFilteringService, ClientFilteringSharedSource clientFilteringSharedSource, ClusterLockManager clusterLockManager) {
        this.clientFilteringService = clientFilteringService;
        this.clientFilteringSharedSource = clientFilteringSharedSource;
        this.clusterLockManager = clusterLockManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventListener
    public void onClusterConnected(ConnectedToClusterEvent event) {
        String clusterName = event.getCluster();
        if (this.clientFilteringService.hasLicensedFeature()) {
            LoggingReadWriteLock lockForCluster = this.clusterLockManager.getLockForCluster(clusterName);
            boolean lockAcquired = lockForCluster.acquireWriteLock();
            if (!lockAcquired) {
                return;
            }
            try {
                ClusterClientFilteringDTO clusterClientFiltering;
                boolean obsoleteConfigRemoved = this.removeObsoleteConfig(clusterName);
                ClusterClientFilteringDTO localConfig = this.clientFilteringService.getFullClientFilteringConfigForCluster(clusterName);
                if (!Objects.equals("00000000-0000-0000-0000-000000000000", localConfig.getEtag()) && (clusterClientFiltering = this.clientFilteringSharedSource.putIfAbsent(clusterName, localConfig)) == null) {
                    this.logConfigUpdated(obsoleteConfigRemoved);
                }
            }
            finally {
                lockForCluster.writeLock().unlock();
            }
        }
    }

    private boolean removeObsoleteConfig(String clusterName) {
        try {
            this.clientFilteringSharedSource.get(clusterName);
            return false;
        }
        catch (HazelcastSerializationException e) {
            this.clientFilteringSharedSource.delete(clusterName);
            return true;
        }
    }

    private void logConfigUpdated(boolean obsoleteConfigRemoved) {
        if (obsoleteConfigRemoved) {
            log.info("An obsolete client filtering config removed from the cluster, put the config from MC");
        } else {
            log.info("There was no client filtering config stored in the cluster, put the config from MC");
        }
    }
}

