/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.hazelcast.webmonitor.metrics.Metric;
import com.hazelcast.webmonitor.metrics.MetricDataPoint;
import com.hazelcast.webmonitor.metrics.MetricDataPointProcessor;
import com.hazelcast.webmonitor.metrics.Tag;
import com.hazelcast.webmonitor.service.Clock;
import com.hazelcast.webmonitor.service.MapIndexRegistry;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import java.util.Map;
import java.util.SortedSet;
import org.springframework.stereotype.Service;

@Service
public class MapIndexStatsManager
implements MetricDataPointProcessor {
    private static final int REGISTRY_MAX_SIZE = 10000;
    private static final int REGISTRY_TTL_MIN = 10;
    private final MapIndexRegistry mapIndexRegistry;

    public MapIndexStatsManager(Clock clock) {
        this.mapIndexRegistry = new MapIndexRegistry(clock, 10000, 10);
    }

    public boolean shouldProcessDataPoint(MetricDataPoint dataPoint) {
        return Metric.MAP_INDEX_CREATION_TIME.getName().equals(dataPoint.getName());
    }

    public void processDataPoint(MetricDataPoint dataPoint, MemberIdentifier memberIdent) {
        Map tags = dataPoint.getTags();
        String mapName = (String)tags.get(Tag.NAME.getName());
        String indexName = (String)tags.get(Tag.INDEX.getName());
        if (mapName != null) {
            this.mapIndexRegistry.register(memberIdent.getClusterName(), mapName, indexName);
        }
    }

    public SortedSet<String> getMapIndexesByMap(String cluster, String mapName) {
        return this.mapIndexRegistry.getIndexesByMap(cluster, mapName);
    }

    public boolean isIndexPresentForMap(String cluster, String mapName) {
        return this.mapIndexRegistry.isIndexPresentForMap(cluster, mapName);
    }
}

