/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ConnectionRetryConfig;
import com.hazelcast.client.config.RoutingMode;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.clientside.HazelcastClientProxy;
import com.hazelcast.client.properties.ClientProperty;
import com.hazelcast.cluster.Member;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.nio.serialization.DataSerializableFactory;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.webmonitor.config.properties.MCClientConfigurationProperties;
import com.hazelcast.webmonitor.controller.exception.ClientFailedToStartApiException;
import com.hazelcast.webmonitor.service.MCClientManager;
import com.hazelcast.webmonitor.service.client.MCClient;
import com.hazelcast.webmonitor.service.exception.NoClientForClusterException;
import com.hazelcast.webmonitor.service.serialization.ClientSerializerFactory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.annotation.Nonnull;
import java.beans.ConstructorProperties;
import java.util.EventListener;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class MCClientManager
implements AutoCloseable {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MCClientManager.class);
    public static final String MC_CLIENT_PREFIX = "MC-Client-";
    private static final long MC_CLIENT_CLUSTER_CONNECT_TIMEOUT_MILLIS = Long.MAX_VALUE;
    private static final int MC_CLIENT_FUTURE_RESOLVE_TIMEOUT = 10;
    private static final int MAX_CLIENT_INSTANTIATION_RETRIES = 10;
    private final ConcurrentMap<String, CompletableFuture<MCClient>> clients = new ConcurrentHashMap();
    private final ReadWriteLock closeInProgressLock = new ReentrantReadWriteLock();
    private boolean closed;
    private final Set<String> connectedClusters = ConcurrentHashMap.newKeySet();
    private final ConcurrentMap<String, Set<Member>> discoveredMembers = new ConcurrentHashMap();
    private final ApplicationEventPublisher publisher;
    private final MCClientConfigurationProperties properties;

    @Override
    public void close() {
        this.closeInProgressLock.writeLock().lock();
        try {
            this.clients.forEach((cluster, clientFuture) -> {
                MCClient mcClient = this.resolveClientFuture(cluster, clientFuture);
                mcClient.shutdown();
            });
            this.closed = true;
        }
        finally {
            this.closeInProgressLock.writeLock().unlock();
        }
    }

    public MCClient connect(ClientConfig clientConfig) {
        String cluster = clientConfig.getClusterName();
        this.closeInProgressLock.readLock().lock();
        try {
            if (this.closed) {
                throw new RuntimeException("MCClientManager has closed!");
            }
            CompletableFuture<MCClient> clientFuture = new CompletableFuture<MCClient>();
            CompletableFuture existingClientFuture = this.clients.put(cluster, clientFuture);
            if (existingClientFuture != null) {
                log.debug("Client connection is already established for cluster {}, waiting for its shutdown before creating a new one.", (Object)cluster);
                try {
                    MCClient existingClient = this.resolveClientFuture(cluster, existingClientFuture);
                    if (existingClient != null) {
                        existingClient.shutdown();
                    }
                }
                catch (Exception e) {
                    log.debug("Couldn't wait for client future resolve", (Throwable)e);
                }
            }
            ClientLifecycleListener lifecycleListener = this.appropriateClientConfig(clientConfig, cluster, clientFuture);
            log.debug("Starting a new MC Client for cluster {}.", (Object)cluster);
            int counter = 0;
            HazelcastClientInstanceImpl hazelcastClient = null;
            do {
                try {
                    hazelcastClient = MCClientManager.toImpl((HazelcastInstance)HazelcastClient.newHazelcastClient((ClientConfig)clientConfig));
                    log.debug("Created Hazelcast client {} with name {}", (Object)hazelcastClient, (Object)clientConfig.getInstanceName());
                }
                catch (InvalidConfigurationException e) {
                    if (counter == 10) {
                        throw e;
                    }
                    clientConfig.setInstanceName("MC-Client-" + counter++ + "-" + cluster);
                    log.warn("Retrying to connect to cluster {}, attempts {}", (Object)cluster, (Object)counter);
                }
            } while (hazelcastClient == null);
            MCClient mcClient = new MCClient(hazelcastClient, lifecycleListener);
            log.debug("Started a new MC Client with id {} for cluster {}.", (Object)mcClient.getClientId(), (Object)cluster);
            clientFuture.complete(mcClient);
            MCClient mCClient = mcClient;
            return mCClient;
        }
        catch (Exception e) {
            log.warn("Couldn't start a new MC client for cluster {}", (Object)cluster, (Object)e);
            throw new ClientFailedToStartApiException((Throwable)e);
        }
        finally {
            this.closeInProgressLock.readLock().unlock();
        }
    }

    private ClientLifecycleListener appropriateClientConfig(ClientConfig clientConfig, String clusterName, CompletableFuture<MCClient> clientFuture) {
        clientConfig.setProperty("hazelcast.client.internal.mc.mode", "true").setProperty(ClientProperty.METRICS_ENABLED.getName(), "false").setProperty(ClusterProperty.LOGGING_TYPE.getName(), "slf4j").setInstanceName("MC-Client-" + clusterName);
        clientConfig.getNetworkConfig().getClusterRoutingConfig().setRoutingMode(RoutingMode.ALL_MEMBERS);
        SerializationConfig serializationConfig = clientConfig.getSerializationConfig();
        serializationConfig.addDataSerializableFactory(1, (DataSerializableFactory)new ClientSerializerFactory());
        clientConfig.getConnectionStrategyConfig().setAsyncStart(true);
        ConnectionRetryConfig retryConfig = clientConfig.getConnectionStrategyConfig().getConnectionRetryConfig();
        retryConfig.setInitialBackoffMillis(this.properties.getInitialBackoffMillis()).setMultiplier((double)this.properties.getBackoffMultiplier()).setMaxBackoffMillis(this.properties.getMaxBackoffMillis());
        if (retryConfig.getClusterConnectTimeoutMillis() < 0L) {
            retryConfig.setClusterConnectTimeoutMillis(Long.MAX_VALUE);
        }
        ClientLifecycleListener lifecycleListener = new ClientLifecycleListener(this, clusterName, clientFuture);
        clientConfig.addListenerConfig(new ListenerConfig((EventListener)lifecycleListener));
        clientConfig.addListenerConfig(new ListenerConfig((EventListener)new MembershipListenerImpl(this, clusterName, clientFuture)));
        return lifecycleListener;
    }

    public void disconnect(String cluster) {
        CompletableFuture clientFuture = (CompletableFuture)this.clients.get(cluster);
        if (clientFuture == null) {
            return;
        }
        try {
            MCClient mcClient = this.resolveClientFuture(cluster, clientFuture);
            if (mcClient != null) {
                mcClient.shutdown();
            }
        }
        catch (NoClientForClusterException noClientForClusterException) {
            // empty catch block
        }
    }

    private MCClient resolveClientFuture(String cluster, CompletableFuture<MCClient> clientFuture) {
        try {
            return clientFuture.get(10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new NoClientForClusterException(cluster, (Throwable)e);
        }
    }

    @Nonnull
    public MCClient clientFor(String cluster) {
        CompletableFuture clientFuture = (CompletableFuture)this.clients.get(cluster);
        if (clientFuture == null) {
            throw new NoClientForClusterException(cluster);
        }
        MCClient client = this.resolveClientFuture(cluster, clientFuture);
        if (client == null) {
            throw new NoClientForClusterException(cluster);
        }
        return client;
    }

    private static HazelcastClientInstanceImpl toImpl(HazelcastInstance instance) {
        if (instance instanceof HazelcastClientInstanceImpl) {
            HazelcastClientInstanceImpl hazelcastClientInstance = (HazelcastClientInstanceImpl)instance;
            return hazelcastClientInstance;
        }
        return ((HazelcastClientProxy)instance).client;
    }

    @ConstructorProperties(value={"publisher", "properties"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public MCClientManager(ApplicationEventPublisher publisher, MCClientConfigurationProperties properties) {
        this.publisher = publisher;
        this.properties = properties;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Set<String> getConnectedClusters() {
        return this.connectedClusters;
    }
}

