/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.hazelcast.webmonitor.controller.dto.metrics.BaseDataPointDTO;
import com.hazelcast.webmonitor.controller.dto.metrics.MetricDTO;
import com.hazelcast.webmonitor.metrics.Metric;
import com.hazelcast.webmonitor.metrics.MetricDataPoint;
import com.hazelcast.webmonitor.metrics.MetricDataPointProcessor;
import com.hazelcast.webmonitor.metrics.MetricsQueryService;
import com.hazelcast.webmonitor.metrics.Tag;
import com.hazelcast.webmonitor.metrics.utils.TimeUtil;
import com.hazelcast.webmonitor.service.Clock;
import com.hazelcast.webmonitor.service.DeviceRegistry;
import com.hazelcast.webmonitor.service.DeviceUsageDTO;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class DeviceStatsManager
implements MetricDataPointProcessor {
    private static final int REGISTRY_MAX_SIZE = 10000;
    private static final int REGISTRY_TTL_MIN = 10;
    private final DeviceRegistry deviceRegistry;
    private final MetricsQueryService metricsQueryService;
    private final Clock clock;

    public DeviceStatsManager(MetricsQueryService metricsQueryService, Clock clock) {
        this.deviceRegistry = new DeviceRegistry(clock, 10000, 10);
        this.metricsQueryService = metricsQueryService;
        this.clock = clock;
    }

    public boolean shouldProcessDataPoint(MetricDataPoint dataPoint) {
        return Metric.TIERED_STORE_DEVICE_CAPACITY.getName().equals(dataPoint.getName());
    }

    public void processDataPoint(MetricDataPoint dataPoint, MemberIdentifier memberIdent) {
        Map tags = dataPoint.getTags();
        String deviceName = (String)tags.get("name");
        if (deviceName != null) {
            this.deviceRegistry.register(memberIdent.getClusterName(), memberIdent.getMemberAddress(), deviceName);
        }
    }

    public SortedSet<String> getDeviceNamesByMember(String cluster, String memberAddress) {
        return this.deviceRegistry.getDeviceNamesByMember(cluster, memberAddress);
    }

    public List<DeviceUsageDTO> getDeviceUsagesByMember(String cluster, String memberAddress) {
        List deviceNames = this.getDeviceNamesByMember(cluster, memberAddress).stream().toList();
        if (deviceNames.isEmpty()) {
            return Collections.emptyList();
        }
        long currentTime = this.clock.currentTimeMillis();
        return deviceNames.stream().map(deviceName -> {
            List dataPoints = this.metricsQueryService.queryLatest(cluster, List.of(MetricDTO.builder().metric(Metric.TIERED_STORE_DEVICE_USED_SPACE).member(memberAddress).tag(Tag.NAME, deviceName).build(), MetricDTO.builder().metric(Metric.TIERED_STORE_DEVICE_CAPACITY).member(memberAddress).tag(Tag.NAME, deviceName).build()), currentTime - TimeUtil.ONE_MINUTE_IN_MS, currentTime);
            return new DeviceUsageDTO(deviceName, (Long)((BaseDataPointDTO)dataPoints.get(0)).getValue(), (Long)((BaseDataPointDTO)dataPoints.get(1)).getValue());
        }).collect(Collectors.toList());
    }
}

