/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.hazelcast.webmonitor.controller.dto.ListDTO;
import com.hazelcast.webmonitor.controller.dto.SetDTO;
import com.hazelcast.webmonitor.metrics.Metric;
import com.hazelcast.webmonitor.metrics.MetricDataPoint;
import com.hazelcast.webmonitor.metrics.MetricDataPointProcessor;
import com.hazelcast.webmonitor.metrics.Tag;
import com.hazelcast.webmonitor.service.Clock;
import com.hazelcast.webmonitor.service.DisconnectedFromClusterEvent;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.annotation.Nonnull;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class CollectionsStatsRegistry
implements MetricDataPointProcessor {
    private static final int REGISTRY_MAX_SIZE = 100000;
    private static final int REGISTRY_TTL_MIN = 1;
    private final Clock clock;
    private final int maxSize;
    private final int ttlMinutes;
    private final ConcurrentMap<String, Cache<String, ListDTO>> knownLists = new ConcurrentHashMap();
    private final ConcurrentMap<String, Cache<String, SetDTO>> knownSets = new ConcurrentHashMap();

    @Autowired
    public CollectionsStatsRegistry(Clock clock) {
        this.clock = clock;
        this.maxSize = 100000;
        this.ttlMinutes = 1;
    }

    @Nonnull
    public Collection<ListDTO> getClusterLists(String cluster) {
        Cache cache = (Cache)this.knownLists.get(cluster);
        return cache == null ? Collections.emptyList() : List.copyOf(cache.asMap().values());
    }

    @Nonnull
    public Collection<SetDTO> getClusterSets(String cluster) {
        Cache cache = (Cache)this.knownSets.get(cluster);
        return cache == null ? Collections.emptyList() : List.copyOf(cache.asMap().values());
    }

    @EventListener
    public void cleanUpDisconnectedCluster(DisconnectedFromClusterEvent event) {
        String cluster = event.getCluster();
        this.knownSets.remove(cluster);
        this.knownLists.remove(cluster);
    }

    public boolean shouldProcessDataPoint(MetricDataPoint dataPoint) {
        String dataPointName = dataPoint.getName();
        return dataPointName.startsWith("set") || dataPointName.startsWith("list");
    }

    public void processDataPoint(MetricDataPoint dataPoint, MemberIdentifier memberIdent) {
        String dataPointName = dataPoint.getName();
        if (dataPointName.startsWith("set")) {
            this.processSetDataPoint(dataPoint, memberIdent);
        } else if (dataPointName.startsWith("list")) {
            this.processListDataPoint(dataPoint, memberIdent);
        }
    }

    private void processListDataPoint(MetricDataPoint dataPoint, MemberIdentifier memberIdent) {
        String listName = (String)dataPoint.getTags().get(Tag.NAME.getName());
        if (listName == null) {
            return;
        }
        String clusterName = memberIdent.getClusterName();
        this.knownLists.computeIfAbsent(clusterName, key -> this.createEntityCache()).asMap().compute(listName, (k, v) -> {
            String metricName;
            ListDTO list = v;
            if (list == null) {
                list = new ListDTO();
                list.setName(listName);
            }
            if ((metricName = dataPoint.getName()).equals(Metric.LIST_CREATION_TIME.getName())) {
                list.setCreationTime(dataPoint.getValue());
            } else if (metricName.equals(Metric.LIST_LAST_ACCESS_TIME.getName()) && dataPoint.getTime() > list.getLastAccessTime() && dataPoint.getValue() > list.getLastAccessTime()) {
                list.setLastAccessTime(dataPoint.getValue());
            } else if (metricName.equals(Metric.LIST_LAST_UPDATE_TIME.getName()) && dataPoint.getTime() > list.getLastUpdateTime() && dataPoint.getValue() > list.getLastUpdateTime()) {
                list.setLastUpdateTime(dataPoint.getValue());
            }
            return list;
        });
    }

    private void processSetDataPoint(MetricDataPoint dataPoint, MemberIdentifier memberIdent) {
        String setName = (String)dataPoint.getTags().get(Tag.NAME.getName());
        if (setName == null) {
            return;
        }
        String clusterName = memberIdent.getClusterName();
        this.knownSets.computeIfAbsent(clusterName, key -> this.createEntityCache()).asMap().compute(setName, (k, v) -> {
            String metricName;
            SetDTO set = v;
            if (set == null) {
                set = new SetDTO();
                set.setName(setName);
            }
            if ((metricName = dataPoint.getName()).equals(Metric.SET_CREATION_TIME.getName())) {
                set.setCreationTime(dataPoint.getValue());
            } else if (metricName.equals(Metric.SET_LAST_ACCESS_TIME.getName()) && dataPoint.getTime() > set.getLastAccessTime() && dataPoint.getValue() > set.getLastAccessTime()) {
                set.setLastAccessTime(dataPoint.getValue());
            } else if (metricName.equals(Metric.SET_LAST_UPDATE_TIME.getName()) && dataPoint.getTime() > set.getLastUpdateTime() && dataPoint.getValue() > set.getLastUpdateTime()) {
                set.setLastUpdateTime(dataPoint.getValue());
            }
            return set;
        });
    }

    private <T> Cache<String, T> createEntityCache() {
        return Caffeine.newBuilder().expireAfterWrite((long)this.ttlMinutes, TimeUnit.MINUTES).maximumSize((long)this.maxSize).ticker(() -> ((Clock)this.clock).nanoTime()).build();
    }

    @ConstructorProperties(value={"clock", "maxSize", "ttlMinutes"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CollectionsStatsRegistry(Clock clock, int maxSize, int ttlMinutes) {
        this.clock = clock;
        this.maxSize = maxSize;
        this.ttlMinutes = ttlMinutes;
    }
}

