/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.instance.ProtocolType;
import com.hazelcast.webmonitor.controller.dto.client.ClientWithConnectionInfoDTO;
import com.hazelcast.webmonitor.controller.dto.clustered.CacheStatsDTO;
import com.hazelcast.webmonitor.controller.dto.clustered.ClientNearCacheStatsDTO;
import com.hazelcast.webmonitor.controller.dto.clustered.ClientStatsDTO;
import com.hazelcast.webmonitor.controller.dto.clustered.ClusterStateDTO;
import com.hazelcast.webmonitor.controller.dto.clustered.ConnectionManagerStatsDTO;
import com.hazelcast.webmonitor.controller.dto.clustered.EventServiceStatsDTO;
import com.hazelcast.webmonitor.controller.dto.clustered.ExecutorStatsDTO;
import com.hazelcast.webmonitor.controller.dto.clustered.FlakeIdGeneratorStatsDTO;
import com.hazelcast.webmonitor.controller.dto.clustered.ManagedExecutorStatsDTO;
import com.hazelcast.webmonitor.controller.dto.clustered.MapStatsDTO;
import com.hazelcast.webmonitor.controller.dto.clustered.MemberStateDTO;
import com.hazelcast.webmonitor.controller.dto.clustered.MemberStatsDTO;
import com.hazelcast.webmonitor.controller.dto.clustered.MultiMapStatsDTO;
import com.hazelcast.webmonitor.controller.dto.clustered.OperationServiceStatsDTO;
import com.hazelcast.webmonitor.controller.dto.clustered.PNCounterStatsDTO;
import com.hazelcast.webmonitor.controller.dto.clustered.PartitionServiceStatsDTO;
import com.hazelcast.webmonitor.controller.dto.clustered.ProxyServiceStatsDTO;
import com.hazelcast.webmonitor.controller.dto.clustered.QueueStatsDTO;
import com.hazelcast.webmonitor.controller.dto.clustered.ReplicatedMapStatsDTO;
import com.hazelcast.webmonitor.controller.dto.clustered.TopicStatsDTO;
import com.hazelcast.webmonitor.controller.dto.clustered.WanRepStatsDTO;
import com.hazelcast.webmonitor.metrics.DataPointAware;
import com.hazelcast.webmonitor.metrics.MetricsService;
import com.hazelcast.webmonitor.metrics.Query;
import com.hazelcast.webmonitor.metrics.imdg.CacheMetricsQueryFactory;
import com.hazelcast.webmonitor.metrics.imdg.ClientMetricsQueryFactory;
import com.hazelcast.webmonitor.metrics.imdg.ClientNearCacheMetricsQueryFactory;
import com.hazelcast.webmonitor.metrics.imdg.CommonMapMetricsQueryFactory;
import com.hazelcast.webmonitor.metrics.imdg.ConnectionManagerMetricsQueryFactory;
import com.hazelcast.webmonitor.metrics.imdg.EventServiceMetricsQueryFactory;
import com.hazelcast.webmonitor.metrics.imdg.ExecutorMetricsQueryFactory;
import com.hazelcast.webmonitor.metrics.imdg.FlakeIdGeneratorMetricsQueryFactory;
import com.hazelcast.webmonitor.metrics.imdg.ManagedExecutorMetricsQueryFactory;
import com.hazelcast.webmonitor.metrics.imdg.MapMetricsQueryFactory;
import com.hazelcast.webmonitor.metrics.imdg.MemberMetricsQueryFactory;
import com.hazelcast.webmonitor.metrics.imdg.MultiMapMetricsQueryFactory;
import com.hazelcast.webmonitor.metrics.imdg.OperationServiceMetricsQueryFactory;
import com.hazelcast.webmonitor.metrics.imdg.PNCounterMetricsQueryFactory;
import com.hazelcast.webmonitor.metrics.imdg.PartitionServiceMetricsQueryFactory;
import com.hazelcast.webmonitor.metrics.imdg.ProxyServiceMetricsQueryFactory;
import com.hazelcast.webmonitor.metrics.imdg.QueueMetricsQueryFactory;
import com.hazelcast.webmonitor.metrics.imdg.ReplicatedMapMetricsQueryFactory;
import com.hazelcast.webmonitor.metrics.imdg.TopicMetricsQueryFactory;
import com.hazelcast.webmonitor.metrics.imdg.WanReplicationMetricsQueryFactory;
import com.hazelcast.webmonitor.model.AllState;
import com.hazelcast.webmonitor.model.InstanceType;
import com.hazelcast.webmonitor.model.hz.req.state.ClientEndPointDTO;
import com.hazelcast.webmonitor.model.hz.req.state.TimedMemberState;
import com.hazelcast.webmonitor.service.ClientNearCacheStatsManager;
import com.hazelcast.webmonitor.service.Clock;
import com.hazelcast.webmonitor.service.MemberManager;
import com.hazelcast.webmonitor.service.StateManager;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class ClusteredStatsService {
    private static final long LOOKUP_INTERVAL_MS = 60000L;
    private final MetricsService metricsService;
    private final MemberManager memberManager;
    private final ClientNearCacheStatsManager nearCacheStatsManager;
    private final Clock clock;
    private final StateManager stateManager;

    public ConnectionManagerStatsDTO getConnectionManagerStats(String cluster, String member) {
        long end = this.clock.currentTimeMillis();
        long start = end - 60000L;
        ConnectionManagerStatsDTO unifiedNetworkStats = this.getCMStatsForUnifiedNetwork(cluster, member, start, end);
        ConnectionManagerStatsDTO advancedNetworkStats = this.getCMStatsForAdvancedNetwork(cluster, member, start, end);
        return unifiedNetworkStats.sum(advancedNetworkStats);
    }

    private ConnectionManagerStatsDTO getCMStatsForUnifiedNetwork(String cluster, String member, long start, long end) {
        ConnectionManagerMetricsQueryFactory unifiedQueryFactory = new ConnectionManagerMetricsQueryFactory.Builder().cluster(cluster).member(member).start(start).end(end).build();
        int clientConnectionCount = (int)this.queryLatest(unifiedQueryFactory.unifiedClientConnectionCountQuery());
        int activeConnectionCount = (int)this.queryLatest(unifiedQueryFactory.activeConnectionCountQuery());
        int connectionCount = (int)this.queryLatest(unifiedQueryFactory.connectionCountQuery());
        return ConnectionManagerStatsDTO.builder().clientConnectionCount(clientConnectionCount).activeConnectionCount(activeConnectionCount).connectionCount(connectionCount).build();
    }

    private ConnectionManagerStatsDTO getCMStatsForAdvancedNetwork(String cluster, String member, long start, long end) {
        ConnectionManagerMetricsQueryFactory.Builder queryFactoryBuilder = new ConnectionManagerMetricsQueryFactory.Builder().cluster(cluster).member(member).start(start).end(end);
        ConnectionManagerMetricsQueryFactory clientQueryFactory = queryFactoryBuilder.endpoint(EndpointQualifier.CLIENT.toMetricsPrefixString()).build();
        int clientConnectionCount = (int)this.queryLatest(clientQueryFactory.connectionCountQuery());
        int activeConnectionCount = 0;
        int connectionCount = 0;
        for (ProtocolType protocolType : ProtocolType.valuesAsSet()) {
            EndpointQualifier endpoint = EndpointQualifier.resolve((ProtocolType)protocolType, null);
            ConnectionManagerMetricsQueryFactory endpointQueryFactory = queryFactoryBuilder.endpoint(endpoint.toMetricsPrefixString()).build();
            activeConnectionCount += (int)this.queryLatest(endpointQueryFactory.activeConnectionCountQuery());
            connectionCount += (int)this.queryLatest(endpointQueryFactory.connectionCountQuery());
        }
        return ConnectionManagerStatsDTO.builder().clientConnectionCount(clientConnectionCount).activeConnectionCount(activeConnectionCount).connectionCount(connectionCount).build();
    }

    public OperationServiceStatsDTO getOperationServiceStats(String cluster, String member) {
        long end = this.clock.currentTimeMillis();
        long start = end - 60000L;
        OperationServiceMetricsQueryFactory queryFactory = new OperationServiceMetricsQueryFactory.Builder().cluster(cluster).member(member).start(start).end(end).build();
        int responseQueueSize = (int)this.queryLatest(queryFactory.responseQueueSizeQuery());
        int operationExecutorQueueSize = (int)this.queryLatest(queryFactory.operationExecutorQueueSizeQuery());
        int runningOperationsCount = (int)this.queryLatest(queryFactory.runningOperationsCountQuery());
        int remoteOperationCount = (int)this.queryLatest(queryFactory.remoteOperationCountQuery());
        long executedOperationCount = this.queryLatest(queryFactory.executedOperationCountQuery());
        long operationThreadCount = this.queryLatest(queryFactory.operationThreadCountQuery());
        return OperationServiceStatsDTO.builder().responseQueueSize(responseQueueSize).operationExecutorQueueSize(operationExecutorQueueSize).runningOperationsCount(runningOperationsCount).remoteOperationCount(remoteOperationCount).executedOperationCount(executedOperationCount).operationThreadCount(operationThreadCount).build();
    }

    public EventServiceStatsDTO getEventServiceStats(String cluster, String member) {
        long end = this.clock.currentTimeMillis();
        long start = end - 60000L;
        EventServiceMetricsQueryFactory queryFactory = new EventServiceMetricsQueryFactory.Builder().cluster(cluster).member(member).start(start).end(end).build();
        int eventThreadCount = (int)this.queryLatest(queryFactory.eventThreadCountQuery());
        int eventQueueCapacity = (int)this.queryLatest(queryFactory.eventQueueCapacityQuery());
        int eventQueueSize = (int)this.queryLatest(queryFactory.eventQueueSizeQuery());
        return EventServiceStatsDTO.builder().eventThreadCount(eventThreadCount).eventQueueCapacity(eventQueueCapacity).eventQueueSize(eventQueueSize).build();
    }

    public PartitionServiceStatsDTO getPartitionServiceStats(String cluster, String member) {
        long end = this.clock.currentTimeMillis();
        long start = end - 60000L;
        PartitionServiceMetricsQueryFactory queryFactory = ((PartitionServiceMetricsQueryFactory.PartitionServiceMetricsQueryFactoryBuilder)((PartitionServiceMetricsQueryFactory.PartitionServiceMetricsQueryFactoryBuilder)((PartitionServiceMetricsQueryFactory.PartitionServiceMetricsQueryFactoryBuilder)((PartitionServiceMetricsQueryFactory.PartitionServiceMetricsQueryFactoryBuilder)PartitionServiceMetricsQueryFactory.builder().cluster(cluster)).member(member)).start(start)).end(end)).build();
        int partitionCount = (int)this.queryLatest(queryFactory.partitionCountQuery());
        int activePartitionCount = (int)this.queryLatest(queryFactory.activePartitionCountQuery());
        return PartitionServiceStatsDTO.builder().partitionCount(partitionCount).activePartitionCount(activePartitionCount).build();
    }

    public ProxyServiceStatsDTO getProxyServiceStats(String cluster, String member) {
        long end = this.clock.currentTimeMillis();
        long start = end - 60000L;
        ProxyServiceMetricsQueryFactory queryFactory = new ProxyServiceMetricsQueryFactory.Builder().cluster(cluster).member(member).start(start).end(end).build();
        int proxyCount = (int)this.queryLatest(queryFactory.proxyCountQuery());
        int createdCount = (int)this.queryLatest(queryFactory.createdCountQuery());
        int destroyedCount = (int)this.queryLatest(queryFactory.destroyedCountQuery());
        return ProxyServiceStatsDTO.builder().proxyCount(proxyCount).createdCount(createdCount).destroyedCount(destroyedCount).build();
    }

    public CacheStatsDTO getCacheStats(String cluster, String cache) {
        long end = this.clock.currentTimeMillis();
        long start = end - 60000L;
        CacheMetricsQueryFactory.Builder queryFactoryBuilder = new CacheMetricsQueryFactory.Builder().cluster(cluster).name(cache).start(start).end(end);
        int localStatsCount = 0;
        long creationTime = 0L;
        long cacheHits = 0L;
        long cacheMisses = 0L;
        long cacheGets = 0L;
        long cachePuts = 0L;
        long cacheRemovals = 0L;
        long cacheEvictions = 0L;
        float averageGetTime = 0.0f;
        float averagePutTime = 0.0f;
        float averageRemoveTime = 0.0f;
        long ownedEntryCount = 0L;
        long lastAccessTime = 0L;
        long lastUpdateTime = 0L;
        List members = this.memberManager.getMemberList(cluster);
        for (String member : members) {
            CacheMetricsQueryFactory queryFactory = queryFactoryBuilder.member(member).build();
            long localCreationTime = this.queryLatest(queryFactory.creationTimeQuery());
            if (localCreationTime > 0L) {
                ++localStatsCount;
            }
            creationTime = Math.max(creationTime, localCreationTime);
            cacheHits += this.queryLatest(queryFactory.hitCountQuery());
            cacheMisses += this.queryLatest(queryFactory.missCountQuery());
            cacheGets += this.queryLatest(queryFactory.getCountQuery());
            cachePuts += this.queryLatest(queryFactory.putCountQuery());
            cacheRemovals += this.queryLatest(queryFactory.removeCountQuery());
            cacheEvictions += this.queryLatest(queryFactory.evictCountQuery());
            averageGetTime = (float)((double)averageGetTime + this.queryLatestDouble(queryFactory.averageGetTimeQuery()));
            averagePutTime = (float)((double)averagePutTime + this.queryLatestDouble(queryFactory.averagePutTimeQuery()));
            averageRemoveTime = (float)((double)averageRemoveTime + this.queryLatestDouble(queryFactory.averageRemoveTimeQuery()));
            ownedEntryCount += this.queryLatest(queryFactory.ownedEntryCountQuery());
            lastAccessTime = Math.max(lastAccessTime, this.queryLatest(queryFactory.lastAccessTimeQuery()));
            lastUpdateTime = Math.max(lastUpdateTime, this.queryLatest(queryFactory.lastUpdateTimeQuery()));
        }
        if (localStatsCount > 0) {
            averageGetTime /= (float)localStatsCount;
            averagePutTime /= (float)localStatsCount;
            averageRemoveTime /= (float)localStatsCount;
        }
        return CacheStatsDTO.builder().cluster(cluster).name(cache).creationTime(creationTime).hits(cacheHits).misses(cacheMisses).getOperationCount(cacheGets).putOperationCount(cachePuts).removeOperationCount(cacheRemovals).evictions(cacheEvictions).averageGetTime(averageGetTime).averagePutTime(averagePutTime).averageRemoveTime(averageRemoveTime).ownedEntryCount(ownedEntryCount).lastAccessTime(lastAccessTime).lastUpdateTime(lastUpdateTime).build();
    }

    public ManagedExecutorStatsDTO getManagedExecutorStats(String cluster, String member, String managedExecutor) {
        long end = this.clock.currentTimeMillis();
        long start = end - 60000L;
        ManagedExecutorMetricsQueryFactory queryFactory = new ManagedExecutorMetricsQueryFactory.Builder().cluster(cluster).member(member).name(managedExecutor).start(start).end(end).build();
        int queueSize = (int)this.queryLatest(queryFactory.queueSizeQuery());
        int poolSize = (int)this.queryLatest(queryFactory.poolSizeQuery());
        int remainingQueueCapacity = (int)this.queryLatest(queryFactory.remainingQueueCapacityQuery());
        int maximumPoolSize = (int)this.queryLatest(queryFactory.maximumPoolSizeQuery());
        long completedTaskCount = this.queryLatest(queryFactory.completedTaskCountQuery());
        return ManagedExecutorStatsDTO.builder().name(managedExecutor).queueSize(queueSize).poolSize(poolSize).remainingQueueCapacity(remainingQueueCapacity).maximumPoolSize(maximumPoolSize).completedTaskCount(completedTaskCount).build();
    }

    public QueueStatsDTO getQueueStats(String cluster, String queue) {
        long end = this.clock.currentTimeMillis();
        long start = end - 60000L;
        QueueMetricsQueryFactory.Builder queryFactoryBuilder = new QueueMetricsQueryFactory.Builder().cluster(cluster).name(queue).start(start).end(end);
        long creationTime = 0L;
        long ownedItemCount = 0L;
        long backupItemCount = 0L;
        long minAge = Long.MAX_VALUE;
        long maxAge = Long.MIN_VALUE;
        long averageAge = 0L;
        long numberOfOffers = 0L;
        long numberOfRejectedOffers = 0L;
        long numberOfPolls = 0L;
        long numberOfEmptyPolls = 0L;
        long numberOfOtherOperations = 0L;
        long numberOfEvents = 0L;
        List members = this.memberManager.getMemberList(cluster);
        for (String member : members) {
            QueueMetricsQueryFactory queryFactory = queryFactoryBuilder.member(member).build();
            creationTime = Math.max(creationTime, this.queryLatest(queryFactory.creationTimeQuery()));
            ownedItemCount += this.queryLatest(queryFactory.ownedItemCountQuery());
            backupItemCount += this.queryLatest(queryFactory.backupItemCountQuery());
            minAge = Math.min(minAge, this.queryLatest(queryFactory.minAgeQuery(), Long.MAX_VALUE));
            maxAge = Math.max(maxAge, this.queryLatest(queryFactory.maxAgeQuery(), Long.MIN_VALUE));
            averageAge += this.queryLatest(queryFactory.averageAgeQuery());
            numberOfOffers += this.queryLatest(queryFactory.numberOfOffersQuery());
            numberOfRejectedOffers += this.queryLatest(queryFactory.numberOfRejectedOffersQuery());
            numberOfPolls += this.queryLatest(queryFactory.numberOfPollsQuery());
            numberOfEmptyPolls += this.queryLatest(queryFactory.numberOfEmptyPollsQuery());
            numberOfOtherOperations += this.queryLatest(queryFactory.numberOfOtherOperationsQuery());
            numberOfEvents += this.queryLatest(queryFactory.numberOfEventsQuery());
        }
        return QueueStatsDTO.builder().cluster(cluster).name(queue).creationTime(creationTime).ownedItemCount(ownedItemCount).backupItemCount(backupItemCount).minAge(minAge).maxAge(maxAge).averageAge(averageAge).offerOperationCount(numberOfOffers).rejectedOffers(numberOfRejectedOffers).pollOperationCount(numberOfPolls).emptyPolls(numberOfEmptyPolls).otherOperationCount(numberOfOtherOperations).events(numberOfEvents).build();
    }

    public TopicStatsDTO getTopicStats(String cluster, String topic, InstanceType instanceType) {
        long end = this.clock.currentTimeMillis();
        long start = end - 60000L;
        TopicMetricsQueryFactory.Builder queryFactoryBuilder = new TopicMetricsQueryFactory.Builder().cluster(cluster).instanceType(instanceType).name(topic).start(start).end(end);
        int numberOfPublishes = 0;
        long totalReceivedMessages = 0L;
        long creationTime = 0L;
        List members = this.memberManager.getMemberList(cluster);
        for (String member : members) {
            TopicMetricsQueryFactory queryFactory = queryFactoryBuilder.member(member).build();
            numberOfPublishes += (int)this.queryLatest(queryFactory.totalPublishesQuery());
            totalReceivedMessages += this.queryLatest(queryFactory.totalReceivedMessagesQuery());
            creationTime = Math.max(creationTime, this.queryLatest(queryFactory.creationTimeQuery()));
        }
        return TopicStatsDTO.builder().cluster(cluster).name(topic).totalPublishes((long)numberOfPublishes).totalReceivedMessages(totalReceivedMessages).creationTime(creationTime).build();
    }

    public PNCounterStatsDTO getPNCounterStats(String cluster, String pnCounter) {
        long end = this.clock.currentTimeMillis();
        long start = end - 60000L;
        PNCounterMetricsQueryFactory.Builder queryFactoryBuilder = new PNCounterMetricsQueryFactory.Builder().cluster(cluster).name(pnCounter).start(start).end(end);
        long creationTime = 0L;
        TreeMap<String, PNCounterStatsDTO.MemberStats> statsPerMember = new TreeMap<String, PNCounterStatsDTO.MemberStats>();
        List members = this.memberManager.getMemberList(cluster);
        for (String member : members) {
            PNCounterMetricsQueryFactory queryFactory = queryFactoryBuilder.member(member).build();
            creationTime = Math.max(creationTime, this.queryLatest(queryFactory.creationTimeQuery()));
            long value = this.queryLatest(queryFactory.valueQuery());
            long totalIncCount = this.queryLatest(queryFactory.totalIncCountQuery());
            long totalDecCount = this.queryLatest(queryFactory.totalDecCountQuery());
            statsPerMember.put(member, new PNCounterStatsDTO.MemberStats(value, totalIncCount, totalDecCount));
        }
        return PNCounterStatsDTO.builder().cluster(cluster).name(pnCounter).creationTime(creationTime).statsPerMember(statsPerMember).build();
    }

    public FlakeIdGeneratorStatsDTO getFlakeIdGeneratorStats(String cluster, String pnCounter) {
        long end = this.clock.currentTimeMillis();
        long start = end - 60000L;
        FlakeIdGeneratorMetricsQueryFactory.Builder queryFactoryBuilder = new FlakeIdGeneratorMetricsQueryFactory.Builder().cluster(cluster).name(pnCounter).start(start).end(end);
        long creationTime = 0L;
        TreeMap<String, FlakeIdGeneratorStatsDTO.MemberStats> statsPerMember = new TreeMap<String, FlakeIdGeneratorStatsDTO.MemberStats>();
        List members = this.memberManager.getMemberList(cluster);
        for (String member : members) {
            FlakeIdGeneratorMetricsQueryFactory queryFactory = queryFactoryBuilder.member(member).build();
            creationTime = Math.max(creationTime, this.queryLatest(queryFactory.creationTimeQuery()));
            long batchRequests = this.queryLatest(queryFactory.batchCountQuery());
            long idCount = this.queryLatest(queryFactory.idCountQuery());
            statsPerMember.put(member, new FlakeIdGeneratorStatsDTO.MemberStats(batchRequests, idCount));
        }
        return FlakeIdGeneratorStatsDTO.builder().cluster(cluster).name(pnCounter).creationTime(creationTime).statsPerMember(statsPerMember).build();
    }

    public WanRepStatsDTO getWanRepStats(String cluster, String wanReplication, String publisher) {
        long end = this.clock.currentTimeMillis();
        long start = end - 60000L;
        WanReplicationMetricsQueryFactory.Builder queryFactoryBuilder = new WanReplicationMetricsQueryFactory.Builder().cluster(cluster).wanReplication(wanReplication).publisher(publisher).start(start).end(end);
        long totalPublishedEventCount = 0L;
        long totalPublishLatency = 0L;
        int outboundQueueSize = 0;
        List members = this.memberManager.getMemberList(cluster);
        for (String member : members) {
            WanReplicationMetricsQueryFactory queryFactory = queryFactoryBuilder.member(member).build();
            totalPublishedEventCount += this.queryLatest(queryFactory.totalPublishedEventCountQuery());
            totalPublishLatency += this.queryLatest(queryFactory.totalPublishLatencyQuery());
            outboundQueueSize += (int)this.queryLatest(queryFactory.outboundQueueSizeQuery());
        }
        return WanRepStatsDTO.builder().cluster(cluster).configName(wanReplication).publisherId(publisher).totalPublishedEventCount(totalPublishedEventCount).totalPublishLatency(totalPublishLatency).outboundQueueSize(outboundQueueSize).build();
    }

    public ExecutorStatsDTO getExecutorStats(String cluster, String executor) {
        long end = this.clock.currentTimeMillis();
        long start = end - 60000L;
        ExecutorMetricsQueryFactory.Builder queryFactoryBuilder = new ExecutorMetricsQueryFactory.Builder().cluster(cluster).name(executor).start(start).end(end);
        long creationTime = 0L;
        long pendingTaskCount = 0L;
        long startedTaskCount = 0L;
        long completedTaskCount = 0L;
        long cancelledTaskCount = 0L;
        long totalExecutionTime = 0L;
        long totalStartLatency = 0L;
        for (String member : this.memberManager.getMemberList(cluster)) {
            ExecutorMetricsQueryFactory queryFactory = queryFactoryBuilder.member(member).build();
            pendingTaskCount += this.queryLatest(queryFactory.pendingTaskQuery());
            startedTaskCount += this.queryLatest(queryFactory.startedTaskQuery());
            completedTaskCount += this.queryLatest(queryFactory.completedTaskQuery());
            cancelledTaskCount += this.queryLatest(queryFactory.cancelledTaskQuery());
            creationTime = Math.max(creationTime, this.queryLatest(queryFactory.creationTimeQuery()));
            totalExecutionTime += this.queryLatest(queryFactory.totalExecutionTimeQuery());
            totalStartLatency += this.queryLatest(queryFactory.totalStartLatencyQuery());
        }
        return ExecutorStatsDTO.builder().cluster(cluster).name(executor).pendingTaskCount(pendingTaskCount).startedTaskCount(startedTaskCount).completedTaskCount(completedTaskCount).cancelledTaskCount(cancelledTaskCount).creationTime(creationTime).totalExecutionTime(totalExecutionTime).totalStartLatency(totalStartLatency).build();
    }

    public MemberStatsDTO getMemberStats(String cluster, String member, TimedMemberState timedMemberState) {
        long end = this.clock.currentTimeMillis();
        long start = end - 60000L;
        MemberMetricsQueryFactory factory = new MemberMetricsQueryFactory.Builder().cluster(cluster).member(member).start(start).end(end).build();
        return MemberStatsDTO.builder().uuid(timedMemberState.getMemberState().getUuid()).cpMemberUuid(timedMemberState.getMemberState().getCpMemberUuid()).version(timedMemberState.getMemberState().getNodeState().getMemberVersion().toString()).maxHeapMemory(this.queryLatest(factory.maxHeapQuery())).ownedPartitionCount((long)timedMemberState.getMemberState().getMemberPartitionState().getPartitions().size()).usedHeapMemory(this.queryLatest(factory.usedHeapQuery())).freeHeapMemory(this.queryLatest(factory.freeHeapQuery())).committedHeapMemory(this.queryLatest(factory.committedHeapQuery())).maxNativeMemory(this.queryLatest(factory.maxNativeQuery())).committedNativeMemory(this.queryLatest(factory.committedNativeQuery())).usedNativeMemory(this.queryLatest(factory.usedNativeQuery())).freeNativeMemory(this.queryLatest(factory.freeNativeQuery())).usedMetadata(this.queryLatest(factory.usedMetadataQuery())).maxMetadata(this.queryLatest(factory.maxMetadataQuery())).master(timedMemberState.isMaster()).connectedClientCount(timedMemberState.getMemberState().getClients().size()).gcMinorCount(this.queryLatest(factory.gcMinorCount())).gcMinorTime(this.queryLatest(factory.gcMinorTime())).gcMajorCount(this.queryLatest(factory.gcMajorCount())).gcMajorTime(this.queryLatest(factory.gcMajorTime())).processCpuLoad(this.queryLatest(factory.processCpuLoad())).systemCpuLoad(this.queryLatest(factory.systemCpuLoad())).systemLoadAverage(this.queryLatest(factory.systemLoadAverage())).threadCount(this.queryLatest(factory.threadCount())).peakThreadCount(this.queryLatest(factory.peakThreadCount())).clientStartedInvocations(this.queryLatest(factory.clientStartedInvocations())).operationQueueSize(this.queryLatest(factory.operationQueueSize())).clusterUpTime(this.queryLatest(factory.clusterUpTime())).clusterLastHeartbeat(this.queryLatest(factory.clusterLastHeartbeat())).cluster(cluster).address(member).build();
    }

    public ClientStatsDTO getClientStats(String cluster, ClientEndPointDTO clientMetadata) {
        long end = this.clock.currentTimeMillis();
        long start = end - 60000L;
        ClientMetricsQueryFactory factory = new ClientMetricsQueryFactory.Builder().cluster(cluster).clientUuid(clientMetadata.getUuid()).clientName(clientMetadata.getName()).start(start).end(end).build();
        EnumMap<InstanceType, Map> nearCacheStats = new EnumMap<InstanceType, Map>(InstanceType.class);
        nearCacheStats.put(InstanceType.MAP, this.getNearCachesStats(cluster, clientMetadata, InstanceType.MAP, start, end));
        nearCacheStats.put(InstanceType.CACHE, this.getNearCachesStats(cluster, clientMetadata, InstanceType.CACHE, start, end));
        Set connectedMembers = this.getConnectedMembers(cluster, clientMetadata.getUuid());
        return ClientStatsDTO.builder().type(clientMetadata.getClientType()).name(clientMetadata.getName()).address(clientMetadata.getIpAddress()).version(clientMetadata.getClientVersion()).connectedMembers(connectedMembers).memberConnection(ClientWithConnectionInfoDTO.inferRoutingMode((ClientEndPointDTO)clientMetadata, (Set)connectedMembers).toString()).clusterConnectionTimestamp(clientMetadata.getClusterConnectionTimestamp()).enterprise(clientMetadata.getEnterprise()).committedVirtualMemorySize(this.queryLatest(factory.committedVirtualMemorySizeQuery())).freePhysicalMemorySize(this.queryLatest(factory.freePhysicalMemorySizeQuery())).freeSwapSpaceSize(this.queryLatest(factory.freeSwapSpaceSizeQuery())).maxFileDescriptorCount(this.queryLatest(factory.maxFileDescriptorCountQuery())).openFileDescriptorCount(this.queryLatest(factory.openFileDescriptorCountQuery())).processCpuTime(this.queryLatest(factory.processCpuTimeQuery())).systemLoadAverage(this.queryLatestDouble(factory.systemLoadAverageQuery())).totalPhysicalMemorySize(this.queryLatest(factory.totalPhysicalMemorySizeQuery())).totalSwapSpaceSize(this.queryLatest(factory.totalSwapSpaceSizeQuery())).availableProcessors((int)this.queryLatest(factory.availableProcessorsQuery())).freeHeapMemory(this.queryLatest(factory.freeMemoryQuery())).maxHeapMemory(this.queryLatest(factory.maxMemoryQuery())).totalHeapMemory(this.queryLatest(factory.totalMemoryQuery())).usedHeapMemory(this.queryLatest(factory.usedMemoryQuery())).uptime(this.queryLatest(factory.uptimeQuery())).nearCacheStats(nearCacheStats).build();
    }

    private String getClientName(String cluster, String clientUuid) {
        return Optional.ofNullable(this.stateManager.getLatestState(cluster)).map(state -> (ClientEndPointDTO)state.getClientsPerUuid().get(clientUuid)).map(ClientEndPointDTO::getName).orElse(null);
    }

    private Set<String> getConnectedMembers(String cluster, String clientUuid) {
        return Optional.ofNullable(this.stateManager.getLatestState(cluster)).map(state -> state.getMembersPerClientUuid(clientUuid)).orElse(Collections.emptySet());
    }

    public MultiMapStatsDTO getMultiMapStats(String cluster, String multiMap) {
        long end = this.clock.currentTimeMillis();
        long start = end - 60000L;
        long ownedEntryCount = 0L;
        long ownedEntryMemoryCost = 0L;
        long backupEntryCount = 0L;
        long backupEntryMemoryCost = 0L;
        long heapCost = 0L;
        long lockedEntryCount = 0L;
        long dirtyEntryCount = 0L;
        long hits = 0L;
        long putOperationCount = 0L;
        long getOperationCount = 0L;
        long removeOperationCount = 0L;
        long otherOperationCount = 0L;
        long events = 0L;
        long lastAccessTime = 0L;
        long lastUpdateTime = 0L;
        long creationTime = 0L;
        long maxPutLatency = 0L;
        long maxGetLatency = 0L;
        long maxRemoveLatency = 0L;
        long totalPutLatency = 0L;
        long totalGetLatency = 0L;
        long totalRemoveLatency = 0L;
        CommonMapMetricsQueryFactory.Builder queryFactoryBuilder = new MultiMapMetricsQueryFactory.Builder().cluster(cluster).name(multiMap).start(start).end(end);
        for (String member : this.memberManager.getMemberList(cluster)) {
            MultiMapMetricsQueryFactory queryFactory = (MultiMapMetricsQueryFactory)queryFactoryBuilder.member(member).build();
            ownedEntryCount += this.queryLatest(queryFactory.ownedEntryCountQuery());
            ownedEntryMemoryCost += this.queryLatest(queryFactory.ownedEntryMemoryCostQuery());
            backupEntryCount += this.queryLatest(queryFactory.backupEntryCountQuery());
            backupEntryMemoryCost += this.queryLatest(queryFactory.backupEntryMemoryCostQuery());
            heapCost += this.queryLatest(queryFactory.heapCostQuery());
            lockedEntryCount += this.queryLatest(queryFactory.lockedEntryCountQuery());
            dirtyEntryCount += this.queryLatest(queryFactory.dirtyEntryCountQuery());
            hits += this.queryLatest(queryFactory.hitsQuery());
            putOperationCount += this.queryLatest(queryFactory.putCountQuery());
            getOperationCount += this.queryLatest(queryFactory.getCountQuery());
            removeOperationCount += this.queryLatest(queryFactory.removeCountQuery());
            otherOperationCount += this.queryLatest(queryFactory.otherOperationCountQuery());
            events += this.queryLatest(queryFactory.eventOperationCountQuery());
            lastAccessTime = Math.max(lastAccessTime, this.queryLatest(queryFactory.lastAccessTimeQuery()));
            lastUpdateTime = Math.max(lastUpdateTime, this.queryLatest(queryFactory.lastUpdateTimeQuery()));
            creationTime = Math.max(creationTime, this.queryLatest(queryFactory.creationTimeQuery()));
            maxPutLatency = Math.max(maxPutLatency, this.queryLatest(queryFactory.totalMaxPutLatencyQuery()));
            maxGetLatency = Math.max(maxGetLatency, this.queryLatest(queryFactory.totalMaxGetLatencyQuery()));
            maxRemoveLatency = Math.max(maxRemoveLatency, this.queryLatest(queryFactory.totalMaxRemoveLatencyQuery()));
            totalPutLatency += this.queryLatest(queryFactory.totalPutLatencyQuery());
            totalGetLatency += this.queryLatest(queryFactory.totalGetLatencyQuery());
            totalRemoveLatency += this.queryLatest(queryFactory.totalRemoveLatencyQuery());
        }
        return MultiMapStatsDTO.builder().name(multiMap).cluster(cluster).ownedEntryCount(ownedEntryCount).ownedEntryMemoryCost(ownedEntryMemoryCost).backupEntryCount(backupEntryCount).backupEntryMemoryCost(backupEntryMemoryCost).heapCost(heapCost).lockedEntryCount(lockedEntryCount).dirtyEntryCount(dirtyEntryCount).hits(hits).putOperationCount(putOperationCount).getOperationCount(getOperationCount).removeOperationCount(removeOperationCount).otherOperationCount(otherOperationCount).events(events).lastAccessTime(lastAccessTime).lastUpdateTime(lastUpdateTime).creationTime(creationTime).maxPutLatency(maxPutLatency).maxGetLatency(maxGetLatency).maxRemoveLatency(maxRemoveLatency).totalPutLatency(totalPutLatency).totalGetLatency(totalGetLatency).totalRemoveLatency(totalRemoveLatency).build();
    }

    public ReplicatedMapStatsDTO getReplicatedMapStats(String cluster, String replicatedMap) {
        long ownedEntryCount = 0L;
        long ownedEntryMemoryCost = 0L;
        long hits = 0L;
        long putOperationCount = 0L;
        long getOperationCount = 0L;
        long removeOperationCount = 0L;
        long otherOperationCount = 0L;
        long events = 0L;
        long lastAccessTime = 0L;
        long lastUpdateTime = 0L;
        long creationTime = 0L;
        long maxPutLatency = 0L;
        long maxGetLatency = 0L;
        long maxRemoveLatency = 0L;
        long totalPutLatency = 0L;
        long totalGetLatency = 0L;
        long totalRemoveLatency = 0L;
        long end = this.clock.currentTimeMillis();
        long start = end - 60000L;
        CommonMapMetricsQueryFactory.Builder queryFactoryBuilder = new ReplicatedMapMetricsQueryFactory.Builder().cluster(cluster).name(replicatedMap).end(end).start(start);
        for (String member : this.memberManager.getMemberList(cluster)) {
            ReplicatedMapMetricsQueryFactory queryFactory = (ReplicatedMapMetricsQueryFactory)queryFactoryBuilder.member(member).build();
            ownedEntryCount += this.queryLatest(queryFactory.ownedEntryCountQuery());
            ownedEntryMemoryCost += this.queryLatest(queryFactory.ownedEntryMemoryCostQuery());
            hits += this.queryLatest(queryFactory.hitsQuery());
            putOperationCount += this.queryLatest(queryFactory.putCountQuery());
            getOperationCount += this.queryLatest(queryFactory.getCountQuery());
            removeOperationCount += this.queryLatest(queryFactory.removeCountQuery());
            otherOperationCount += this.queryLatest(queryFactory.otherOperationCountQuery());
            events += this.queryLatest(queryFactory.eventOperationCountQuery());
            lastAccessTime = Math.max(lastAccessTime, this.queryLatest(queryFactory.lastAccessTimeQuery()));
            lastUpdateTime = Math.max(lastUpdateTime, this.queryLatest(queryFactory.lastUpdateTimeQuery()));
            creationTime = Math.max(creationTime, this.queryLatest(queryFactory.creationTimeQuery()));
            maxPutLatency = Math.max(maxPutLatency, this.queryLatest(queryFactory.totalMaxPutLatencyQuery()));
            maxGetLatency = Math.max(maxGetLatency, this.queryLatest(queryFactory.totalMaxGetLatencyQuery()));
            maxRemoveLatency = Math.max(maxRemoveLatency, this.queryLatest(queryFactory.totalMaxRemoveLatencyQuery()));
            totalPutLatency += this.queryLatest(queryFactory.totalPutLatencyQuery());
            totalGetLatency += this.queryLatest(queryFactory.totalGetLatencyQuery());
            totalRemoveLatency += this.queryLatest(queryFactory.totalRemoveLatencyQuery());
        }
        return ReplicatedMapStatsDTO.builder().name(replicatedMap).cluster(cluster).ownedEntryCount(ownedEntryCount).ownedEntryMemoryCost(ownedEntryMemoryCost).hits(hits).putOperationCount(putOperationCount).getOperationCount(getOperationCount).removeOperationCount(removeOperationCount).otherOperationCount(otherOperationCount).events(events).lastAccessTime(lastAccessTime).lastUpdateTime(lastUpdateTime).creationTime(creationTime).maxPutLatency(maxPutLatency).maxGetLatency(maxGetLatency).maxRemoveLatency(maxRemoveLatency).totalPutLatency(totalPutLatency).totalGetLatency(totalGetLatency).totalRemoveLatency(totalRemoveLatency).build();
    }

    public MapStatsDTO getMapStats(String cluster, String map) {
        long end = this.clock.currentTimeMillis();
        long start = end - 60000L;
        long totalPutLatency = 0L;
        long totalGetLatency = 0L;
        long totalRemoveLatency = 0L;
        long totalSetLatency = 0L;
        long ownedEntryCount = 0L;
        long ownedEntryMemoryCost = 0L;
        long backupEntryCount = 0L;
        long backupEntryMemoryCost = 0L;
        long heapCost = 0L;
        long lockedEntryCount = 0L;
        long dirtyEntryCount = 0L;
        long hits = 0L;
        long putOperationCount = 0L;
        long getOperationCount = 0L;
        long removeOperationCount = 0L;
        long setOperationCount = 0L;
        long otherOperationCount = 0L;
        long events = 0L;
        long lastAccessTime = 0L;
        long lastUpdateTime = 0L;
        long creationTime = 0L;
        long maxPutLatency = 0L;
        long maxGetLatency = 0L;
        long maxRemoveLatency = 0L;
        long maxSetLatency = 0L;
        CommonMapMetricsQueryFactory.Builder queryFactoryBuilder = new MapMetricsQueryFactory.Builder().cluster(cluster).name(map).start(start).end(end);
        for (String member : this.memberManager.getMemberList(cluster)) {
            MapMetricsQueryFactory queryFactory = (MapMetricsQueryFactory)queryFactoryBuilder.member(member).build();
            ownedEntryCount += this.queryLatest(queryFactory.ownedEntryCountQuery());
            ownedEntryMemoryCost += this.queryLatest(queryFactory.ownedEntryMemoryCostQuery());
            backupEntryCount += this.queryLatest(queryFactory.backupEntryCountQuery());
            backupEntryMemoryCost += this.queryLatest(queryFactory.backupEntryMemoryCostQuery());
            heapCost += this.queryLatest(queryFactory.heapCostQuery());
            lockedEntryCount += this.queryLatest(queryFactory.lockedEntryCountQuery());
            dirtyEntryCount += this.queryLatest(queryFactory.dirtyEntryCountQuery());
            hits += this.queryLatest(queryFactory.hitsQuery());
            putOperationCount += this.queryLatest(queryFactory.putCountQuery());
            getOperationCount += this.queryLatest(queryFactory.getCountQuery());
            removeOperationCount += this.queryLatest(queryFactory.removeCountQuery());
            setOperationCount += this.queryLatest(queryFactory.setCountQuery());
            otherOperationCount += this.queryLatest(queryFactory.otherOperationCountQuery());
            events += this.queryLatest(queryFactory.eventOperationCountQuery());
            lastAccessTime = Math.max(lastAccessTime, this.queryLatest(queryFactory.lastAccessTimeQuery()));
            lastUpdateTime = Math.max(lastUpdateTime, this.queryLatest(queryFactory.lastUpdateTimeQuery()));
            creationTime = Math.max(creationTime, this.queryLatest(queryFactory.creationTimeQuery()));
            maxPutLatency = Math.max(maxPutLatency, this.queryLatest(queryFactory.totalMaxPutLatencyQuery()));
            maxGetLatency = Math.max(maxGetLatency, this.queryLatest(queryFactory.totalMaxGetLatencyQuery()));
            maxRemoveLatency = Math.max(maxRemoveLatency, this.queryLatest(queryFactory.totalMaxRemoveLatencyQuery()));
            maxSetLatency = Math.max(maxSetLatency, this.queryLatest(queryFactory.totalMaxSetLatencyQuery()));
            totalPutLatency += this.queryLatest(queryFactory.totalPutLatencyQuery());
            totalGetLatency += this.queryLatest(queryFactory.totalGetLatencyQuery());
            totalRemoveLatency += this.queryLatest(queryFactory.totalRemoveLatencyQuery());
            totalSetLatency += this.queryLatest(queryFactory.totalSetLatencyQuery());
        }
        return MapStatsDTO.builder().name(map).cluster(cluster).ownedEntryCount(ownedEntryCount).ownedEntryMemoryCost(ownedEntryMemoryCost).backupEntryCount(backupEntryCount).backupEntryMemoryCost(backupEntryMemoryCost).heapCost(heapCost).lockedEntryCount(lockedEntryCount).dirtyEntryCount(dirtyEntryCount).hits(hits).putOperationCount(putOperationCount).getOperationCount(getOperationCount).removeOperationCount(removeOperationCount).setOperationCount(setOperationCount).otherOperationCount(otherOperationCount).events(events).lastAccessTime(lastAccessTime).lastUpdateTime(lastUpdateTime).creationTime(creationTime).maxPutLatency(maxPutLatency).maxGetLatency(maxGetLatency).maxRemoveLatency(maxRemoveLatency).maxSetLatency(maxSetLatency).totalPutLatency(totalPutLatency).totalGetLatency(totalGetLatency).totalRemoveLatency(totalRemoveLatency).totalSetLatency(totalSetLatency).build();
    }

    public ClusterStateDTO getClusterState(String cluster, AllState allState) {
        HashMap<Object, MemberStatsDTO> allMemberStats = new HashMap<Object, MemberStatsDTO>();
        HashMap<Object, MemberStateDTO> allMemberStates = new HashMap<Object, MemberStateDTO>();
        for (Object member : allState.getMembers()) {
            TimedMemberState timedMemberState = (TimedMemberState)allState.getTimedMemberStates().get((String)member);
            if (timedMemberState == null) continue;
            MemberStatsDTO memberStats = this.getMemberStats(cluster, (String)member, timedMemberState);
            allMemberStats.put(member, memberStats);
            MemberStateDTO memberState = MemberStateDTO.builder().hotRestartState(timedMemberState.getMemberState().getHotRestartState()).build();
            allMemberStates.put(member, memberState);
        }
        HashMap<String, ClientStatsDTO> allClientStats = new HashMap<String, ClientStatsDTO>();
        for (Map.Entry entry : allState.getStatsEnabledClients().entrySet()) {
            ClientStatsDTO clientStats = this.getClientStats(cluster, (ClientEndPointDTO)entry.getValue());
            allClientStats.put((String)entry.getKey(), clientStats);
        }
        HashMap<String, MapStatsDTO> allMapStats = new HashMap<String, MapStatsDTO>();
        for (String map : allState.getInstanceNames(InstanceType.MAP)) {
            MapStatsDTO mapStats = this.getMapStats(cluster, map);
            allMapStats.put(map, mapStats);
        }
        return ClusterStateDTO.builder().time(allState.getTime()).memberStates(allMemberStates).memberStats(allMemberStats).clientStats(allClientStats).mapStats(allMapStats).build();
    }

    private Map<String, ClientNearCacheStatsDTO> getNearCachesStats(String cluster, ClientEndPointDTO clientMetadata, InstanceType instanceType, long start, long end) {
        HashMap<String, ClientNearCacheStatsDTO> map = new HashMap<String, ClientNearCacheStatsDTO>();
        for (String name : this.nearCacheStatsManager.getDataStructuresByClient(cluster, clientMetadata.getUuid(), instanceType)) {
            map.put(name, this.getNearCacheStats(cluster, clientMetadata.getUuid(), clientMetadata.getName(), instanceType, name, start, end));
        }
        return map;
    }

    public ClientNearCacheStatsDTO getNearCacheStats(String cluster, String clientUuid, InstanceType instanceType, String dataStructureName) {
        long end = this.clock.currentTimeMillis();
        long start = end - 60000L;
        String clientName = this.getClientName(cluster, clientUuid);
        return this.getNearCacheStats(cluster, clientUuid, clientName, instanceType, dataStructureName, start, end);
    }

    private ClientNearCacheStatsDTO getNearCacheStats(String cluster, String clientUuid, String clientName, InstanceType instanceType, String dataStructureName, long start, long end) {
        ClientNearCacheMetricsQueryFactory queryFactory = new ClientNearCacheMetricsQueryFactory.Builder().cluster(cluster).clientUuid(clientUuid).clientName(clientName).instanceType(instanceType).name(dataStructureName).end(end).start(start).build();
        return ClientNearCacheStatsDTO.builder().clientUuid(clientUuid).creationTime(this.queryLatest(queryFactory.creationTimeQuery())).evictions(this.queryLatest(queryFactory.evictionsQuery())).expirations(this.queryLatest(queryFactory.expirationsQuery())).hits(this.queryLatest(queryFactory.hitsQuery())).misses(this.queryLatest(queryFactory.missesQuery())).ownedEntryCount(this.queryLatest(queryFactory.ownedEntryCountQuery())).ownedEntryMemoryCost(this.queryLatest(queryFactory.ownedEntryMemoryCostQuery())).lastPersistenceDuration(this.queryLatest(queryFactory.lastPersistenceDurationQuery())).lastPersistenceKeyCount(this.queryLatest(queryFactory.lastPersistenceKeyCountQuery())).lastPersistenceTime(this.queryLatest(queryFactory.lastPersistenceTimeQuery())).lastPersistenceWrittenBytes(this.queryLatest(queryFactory.lastPersistenceWrittenBytesQuery())).build();
    }

    private long queryLatest(Query query) {
        return this.queryLatest(query, 0L);
    }

    private long queryLatest(Query query, long defaultValue) {
        return this.metricsService.queryLatestRaw(query).map(DataPointAware::getValue).orElse(defaultValue);
    }

    private double queryLatestDouble(Query query) {
        return this.metricsService.queryLatestRaw(query).map(DataPointAware::getDoubleValue).orElse(0.0);
    }

    @ConstructorProperties(value={"metricsService", "memberManager", "nearCacheStatsManager", "clock", "stateManager"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ClusteredStatsService(MetricsService metricsService, MemberManager memberManager, ClientNearCacheStatsManager nearCacheStatsManager, Clock clock, StateManager stateManager) {
        this.metricsService = metricsService;
        this.memberManager = memberManager;
        this.nearCacheStatsManager = nearCacheStatsManager;
        this.clock = clock;
        this.stateManager = stateManager;
    }
}

