/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.hazelcast.webmonitor.controller.dto.jet.DagDTO;
import com.hazelcast.webmonitor.controller.dto.jet.EdgeInfoDTO;
import com.hazelcast.webmonitor.controller.dto.jet.ExportedJobSnapshotDTO;
import com.hazelcast.webmonitor.controller.dto.jet.JetStatus;
import com.hazelcast.webmonitor.controller.dto.jet.JobInfoDTO;
import com.hazelcast.webmonitor.controller.dto.jet.MinimizedJobInfoDTO;
import com.hazelcast.webmonitor.controller.dto.jet.VertexInfoDTO;
import com.hazelcast.webmonitor.service.ClusterManager;
import com.hazelcast.webmonitor.service.ClusteredJetStatsAggregator;
import com.hazelcast.webmonitor.service.ClusteredJetStatsProvider;
import com.hazelcast.webmonitor.service.ConnectedToClusterEvent;
import com.hazelcast.webmonitor.service.DisconnectedFromClusterEvent;
import com.hazelcast.webmonitor.service.ScheduledOperationChainRegistry;
import com.hazelcast.webmonitor.service.jet.JetService;
import com.hazelcast.webmonitor.utils.ExecutorServiceShutdownUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;

/*
 * Exception performing whole class analysis ignored.
 */
public class ClusteredJetStatsAggregator
implements AutoCloseable,
ClusteredJetStatsProvider {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClusteredJetStatsAggregator.class);
    private static final int DEFAULT_THREAD_POOL_SIZE = 4;
    private static final int DEFAULT_SCHEDULER_DELAY_MS = 5000;
    private final JetService jetService;
    private final ClusterManager clusterManager;
    private final ScheduledExecutorService executor;
    private final int schedulerDelayMs;
    private final ScheduledOperationChainRegistry<String> chainIdRegistry;
    private final LoadingCache<String, Map<String, ClusteredJobInfoDTO>> jobsByCluster;
    private final LoadingCache<String, Map<String, ExportedJobSnapshotDTO>> snapshotsByCluster;

    public ClusteredJetStatsAggregator(JetService jetService, ClusterManager clusterManager) {
        this(jetService, clusterManager, 5000, 4);
    }

    ClusteredJetStatsAggregator(JetService jetService, ClusterManager clusterManager, int schedulerDelayMs, int threadPoolSize) {
        this.jetService = jetService;
        this.clusterManager = clusterManager;
        this.schedulerDelayMs = schedulerDelayMs;
        this.chainIdRegistry = new ScheduledOperationChainRegistry();
        long cacheTtlMs = (long)schedulerDelayMs * 3L;
        this.jobsByCluster = ClusteredJetStatsAggregator.cacheWithTtl((long)cacheTtlMs);
        this.snapshotsByCluster = ClusteredJetStatsAggregator.cacheWithTtl((long)cacheTtlMs);
        this.executor = Executors.newScheduledThreadPool(threadPoolSize, new ThreadFactoryBuilder().setNameFormat("ClusteredJetStatsAggregator-%d").build());
    }

    private static <T> LoadingCache<String, Map<String, T>> cacheWithTtl(long ttlMs) {
        return Caffeine.newBuilder().expireAfterWrite(ttlMs, TimeUnit.MILLISECONDS).build(key -> Collections.emptyMap());
    }

    @EventListener
    public void onClusterConnected(ConnectedToClusterEvent event) {
        String clusterName = event.getCluster();
        this.scheduleNextPoll(this.nextChainId(clusterName), clusterName, 0L);
    }

    @EventListener
    public void onDisconnectedFromCluster(DisconnectedFromClusterEvent event) {
        String cluster = event.getCluster();
        int id = this.nextChainId(cluster);
        this.chainIdRegistry.cleanUp((Object)cluster, id);
    }

    public Map<String, ClusteredJobInfoDTO> getJobs(String cluster) {
        return (Map)this.jobsByCluster.get((Object)cluster);
    }

    public Map<String, ExportedJobSnapshotDTO> getSnapshots(String cluster) {
        return (Map)this.snapshotsByCluster.get((Object)cluster);
    }

    private void runPoll(int chainId, String clusterName) {
        if (!this.chainIdRegistry.sameAsCurrentId((Object)clusterName, chainId)) {
            return;
        }
        try {
            if (this.clusterManager.getJetStatus(clusterName) == JetStatus.ENABLED) {
                this.fetchJetStats(clusterName);
            } else {
                this.jobsByCluster.refresh((Object)clusterName);
                this.snapshotsByCluster.refresh((Object)clusterName);
            }
        }
        catch (Exception e) {
            if (this.clusterManager.isClusterConnected(clusterName)) {
                log.error("Failed to aggregate Jet stats for the cluster {}.", (Object)clusterName, (Object)e);
            }
            log.debug("Failed to aggregate Jet stats for the cluster {}.", (Object)clusterName, (Object)e);
        }
        this.scheduleNextPoll(chainId, clusterName, (long)this.schedulerDelayMs);
    }

    private void scheduleNextPoll(int chainId, String clusterName, long delayMs) {
        this.executor.schedule(() -> {
            try {
                this.runPoll(chainId, clusterName);
            }
            catch (Exception e) {
                log.error("Unexpected error when polling Jet stats from the cluster {}.", (Object)clusterName, (Object)e);
            }
        }, delayMs, TimeUnit.MILLISECONDS);
    }

    @Override
    public void close() {
        ExecutorServiceShutdownUtils.shutdownExecutorService((ExecutorService)this.executor);
    }

    void fetchJetStats(String cluster) {
        HashMap<String, ClusteredJobInfoDTO> jobsForCluster = new HashMap<String, ClusteredJobInfoDTO>();
        HashMap<String, ExportedJobSnapshotDTO> snapshotsForCluster = new HashMap<String, ExportedJobSnapshotDTO>();
        for (MinimizedJobInfoDTO job : this.jetService.getJobs(cluster)) {
            JobInfoDTO jobInfo = this.jetService.getJobInfo(cluster, job.getId());
            ArrayList<VertexInfoDTO> vertices = new ArrayList<VertexInfoDTO>();
            ArrayList<EdgeInfoDTO> edges = new ArrayList<EdgeInfoDTO>();
            DagDTO dag = jobInfo.getDag();
            if (dag != null) {
                for (DagDTO.VertexDTO vertex : dag.getVertices()) {
                    vertices.add(this.jetService.getVertexDetails(cluster, job.getId(), vertex.getName()));
                }
                for (DagDTO.EdgeDTO edge : dag.getEdges()) {
                    EdgeInfoDTO edgeInfo = this.jetService.lookUpEdgeInfo(cluster, job.getId(), edge.getFrom(), edge.getFromOrdinal(), edge.getTo(), edge.getToOrdinal());
                    edges.add(edgeInfo);
                }
            }
            jobsForCluster.put(jobInfo.getId(), new ClusteredJobInfoDTO(jobInfo, vertices, edges));
        }
        for (ExportedJobSnapshotDTO exportedSnapshot : this.jetService.getExportedSnapshots(cluster)) {
            snapshotsForCluster.put(exportedSnapshot.getName(), exportedSnapshot);
        }
        this.jobsByCluster.put((Object)cluster, jobsForCluster);
        this.snapshotsByCluster.put((Object)cluster, snapshotsForCluster);
    }

    int nextChainId(String cluster) {
        return this.chainIdRegistry.nextId((Object)cluster);
    }

    @ConstructorProperties(value={"jetService", "clusterManager", "executor", "schedulerDelayMs", "chainIdRegistry", "jobsByCluster", "snapshotsByCluster"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ClusteredJetStatsAggregator(JetService jetService, ClusterManager clusterManager, ScheduledExecutorService executor, int schedulerDelayMs, ScheduledOperationChainRegistry<String> chainIdRegistry, LoadingCache<String, Map<String, ClusteredJobInfoDTO>> jobsByCluster, LoadingCache<String, Map<String, ExportedJobSnapshotDTO>> snapshotsByCluster) {
        this.jetService = jetService;
        this.clusterManager = clusterManager;
        this.executor = executor;
        this.schedulerDelayMs = schedulerDelayMs;
        this.chainIdRegistry = chainIdRegistry;
        this.jobsByCluster = jobsByCluster;
        this.snapshotsByCluster = snapshotsByCluster;
    }
}

