/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.security.spi.impl.activedirectory;

import com.hazelcast.webmonitor.config.properties.ADConfigurationProperties;
import com.hazelcast.webmonitor.config.properties.SSLProperties;
import com.hazelcast.webmonitor.security.spi.SecurityConfigApiException;
import com.hazelcast.webmonitor.security.spi.impl.SecurityConfigImportService;
import com.hazelcast.webmonitor.security.spi.impl.SecurityProviderConfig;
import com.hazelcast.webmonitor.security.spi.impl.activedirectory.ActiveDirectoryAuthenticationProvider;
import com.hazelcast.webmonitor.security.spi.impl.activedirectory.ActiveDirectoryConfig;
import com.hazelcast.webmonitor.security.spi.impl.activedirectory.PersistentActiveDirectoryConfig;
import com.hazelcast.webmonitor.security.spi.impl.ldap.AbstractLdapSecurityProvider;
import com.hazelcast.webmonitor.security.spi.impl.ldap.LdapUserDetailsContextMapper;
import com.hazelcast.webmonitor.ssl.SSLContextFactory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.CommunicationException;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.ldap.userdetails.UserDetailsContextMapper;

public class ActiveDirectorySecurityProvider
extends AbstractLdapSecurityProvider {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ActiveDirectorySecurityProvider.class);
    public static final String ACTIVE_DIRECTORY_SECURITY_PROVIDER_NAME = "Active Directory";
    private final PersistentActiveDirectoryConfig persistentActiveDirectoryConfig;
    private final SecurityConfigImportService securityConfigImportService;
    private final int connectionTimeout;
    private final ADConfigurationProperties adProperties;
    private AuthenticationProvider authenticationProvider;

    public String getName() {
        return ACTIVE_DIRECTORY_SECURITY_PROVIDER_NAME;
    }

    public void saveConfig(Map<String, String> parameters) {
        ActiveDirectoryConfig ldapConfig = ActiveDirectoryConfig.fromMap(parameters);
        this.persistentActiveDirectoryConfig.write((SecurityProviderConfig)ldapConfig);
        this.authenticationProvider = this.createAuthenticationProvider(ldapConfig);
    }

    public AuthenticationProvider getAuthenticationProvider() {
        if (this.authenticationProvider == null) {
            ActiveDirectoryConfig activeDirectoryConfig = this.persistentActiveDirectoryConfig.get();
            this.authenticationProvider = this.createAuthenticationProvider(activeDirectoryConfig);
        }
        return this.authenticationProvider;
    }

    public Optional<String> testConfig(String testUsername, String testPassword, Map<String, String> parameters) {
        Authentication authentication;
        try {
            ActiveDirectoryConfig activeDirectoryConfig = ActiveDirectoryConfig.fromMap(parameters);
            ActiveDirectoryAuthenticationProvider provider = this.createAuthenticationProvider(activeDirectoryConfig);
            authentication = provider.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)testUsername, (Object)testPassword));
        }
        catch (CommunicationException e) {
            log.info(e.getMessage(), (Throwable)e);
            throw new SecurityConfigApiException("Failed to communicate with Active Directory server. Check the URL.");
        }
        catch (BadCredentialsException e) {
            log.info(e.getMessage(), (Throwable)e);
            throw new SecurityConfigApiException("Wrong credentials. Check the domain along with test user credentials.");
        }
        catch (Exception e) {
            log.info(e.getMessage(), (Throwable)e);
            throw new SecurityConfigApiException(e.getMessage());
        }
        Collection authorities = authentication.getAuthorities();
        if (authorities.isEmpty()) {
            throw new SecurityConfigApiException("User has no roles. Check the group names and make sure the test user is a member of one of the groups (or its nested groups).");
        }
        return Optional.of(((GrantedAuthority)authorities.iterator().next()).getAuthority());
    }

    public void reloadConfig() {
        ActiveDirectoryConfig activeDirectoryConfig = ActiveDirectoryConfig.fromProperties((Properties)this.securityConfigImportService.readProperties());
        this.persistentActiveDirectoryConfig.write((SecurityProviderConfig)activeDirectoryConfig);
        this.authenticationProvider = this.createAuthenticationProvider(activeDirectoryConfig);
        this.securityConfigImportService.cleanupOnSuccessfulImport();
    }

    public boolean reloadConfigAvailable() {
        return this.securityConfigImportService.importPropertiesAvailable();
    }

    private ActiveDirectoryAuthenticationProvider createAuthenticationProvider(ActiveDirectoryConfig config) {
        if (this.isSslConnection(config.getUrl())) {
            log.info("Using LDAP over SSL for Active Directory authentication.");
            try {
                SSLContext.setDefault(SSLContextFactory.createSSLContext((SSLProperties)this.adProperties.getSsl()));
            }
            catch (Exception e) {
                log.warn("Failed to enable ldaps for Active Directory.", (Throwable)e);
            }
        }
        ActiveDirectoryAuthenticationProvider provider = new ActiveDirectoryAuthenticationProvider(config.getDomain(), config.getUrl(), config.isNestedGroupSearch(), this.connectionTimeout);
        provider.setSearchFilter(config.getUserSearchFilter());
        provider.setUserDetailsContextMapper((UserDetailsContextMapper)new LdapUserDetailsContextMapper(config.getGroupsToRolesMappingConfig()));
        return provider;
    }

    @ConstructorProperties(value={"persistentActiveDirectoryConfig", "securityConfigImportService", "connectionTimeout", "adProperties"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ActiveDirectorySecurityProvider(PersistentActiveDirectoryConfig persistentActiveDirectoryConfig, SecurityConfigImportService securityConfigImportService, int connectionTimeout, ADConfigurationProperties adProperties) {
        this.persistentActiveDirectoryConfig = persistentActiveDirectoryConfig;
        this.securityConfigImportService = securityConfigImportService;
        this.connectionTimeout = connectionTimeout;
        this.adProperties = adProperties;
    }
}

