/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.security.spi;

import com.hazelcast.webmonitor.security.spi.SecurityConfigParameter;
import com.hazelcast.webmonitor.security.spi.impl.GroupsToRolesMappingConfig;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public interface SecurityProvider {
    public static final String ROLE_ADMIN = "ROLE_ADMIN";
    public static final String ROLE_USER = "ROLE_USER";
    public static final String ROLE_READONLY_USER = "ROLE_READONLY_USER";
    public static final String ROLE_METRICS_ONLY = "ROLE_METRICS_ONLY";
    public static final String ROLE_CLOUD_USER = "ROLE_CLOUD_USER";
    public static final GrantedAuthority ADMIN_AUTHORITY = new SimpleGrantedAuthority("ROLE_ADMIN");
    public static final GrantedAuthority USER_AUTHORITY = new SimpleGrantedAuthority("ROLE_USER");
    public static final GrantedAuthority READONLY_USER_AUTHORITY = new SimpleGrantedAuthority("ROLE_READONLY_USER");
    public static final GrantedAuthority METRICS_ONLY_AUTHORITY = new SimpleGrantedAuthority("ROLE_METRICS_ONLY");
    public static final Map<String, List<SecurityConfigParameter>> CONFIG_PARAMETERS = Map.of("Default", List.of(SecurityConfigParameter.stringParam((String)"username", (String)"Username"), SecurityConfigParameter.secretParam((String)"password", (String)"Password"), SecurityConfigParameter.secretParam((String)"confirmPassword", (String)"Confirm Password")), "Active Directory", Stream.concat(Stream.of(SecurityConfigParameter.stringParam((String)"url", (String)"URL", (String)"ldap://localhost:10389"), SecurityConfigParameter.stringParam((String)"domain", (String)"Domain", (String)"example.com"), SecurityConfigParameter.stringParam((String)"userSearchFilter", (String)"User Search Filter", (String)"(&(objectClass=user)(userPrincipalName={0}))"), SecurityConfigParameter.boolParam((String)"nestedGroupSearch", (String)"Nested Group Search", (boolean)true)), GroupsToRolesMappingConfig.CONFIG_PARAMETERS.stream()).toList(), "JAAS", Stream.concat(Stream.of(SecurityConfigParameter.stringParam((String)"loginModuleClass", (String)"Login Module Class", (String)"com.yourcompany.MyLoginModule")), GroupsToRolesMappingConfig.CONFIG_PARAMETERS.stream()).toList(), "LDAP", Stream.concat(Stream.of(SecurityConfigParameter.stringParam((String)"url", (String)"URL", (String)"ldap://localhost:10389"), SecurityConfigParameter.stringParam((String)"username", (String)"Distinguished name (DN) of user", (String)"cn=Some User,cn=users,dc=example,dc=com"), SecurityConfigParameter.secretParam((String)"password", (String)"Password"), SecurityConfigParameter.stringParam((String)"userDn", (String)"User DN", (String)"ou=users,o=yourorg"), SecurityConfigParameter.stringParam((String)"groupDn", (String)"Group DN", (String)"ou=groups,o=yourorg"), SecurityConfigParameter.boolParam((String)"startTls", (String)"Start TLS"), SecurityConfigParameter.stringParam((String)"userSearchFilter", (String)"User Search Filter", (String)"uid={0}"), SecurityConfigParameter.stringParam((String)"groupSearchFilter", (String)"Group Search Filter", (String)"uniquemember={0}"), SecurityConfigParameter.boolParam((String)"nestedGroupSearch", (String)"Nested Group Search", (boolean)true)), GroupsToRolesMappingConfig.CONFIG_PARAMETERS.stream()).toList(), "OpenID Connect", Stream.concat(Stream.of(SecurityConfigParameter.stringParam((String)"clientID", (String)"Client ID"), SecurityConfigParameter.sensitiveStringParam((String)"clientSecret", (String)"Client Secret"), SecurityConfigParameter.stringParam((String)"authorizationEndpoint", (String)"Authorization Endpoint"), SecurityConfigParameter.stringParam((String)"userInfoEndpoint", (String)"User Info Endpoint"), SecurityConfigParameter.stringParam((String)"tokenEndpoint", (String)"Token Endpoint"), SecurityConfigParameter.stringParam((String)"jwkSetEndpoint", (String)"JWK Set Endpoint"), SecurityConfigParameter.stringParam((String)"issuer", (String)"Issuer"), SecurityConfigParameter.stringParam((String)"scope", (String)"Scope", (String)"openid profile groups"), SecurityConfigParameter.stringParam((String)"redirectURL", (String)"Redirect URL"), SecurityConfigParameter.stringParam((String)"userIdClaimName", (String)"User ID Claim Name", (String)"preferred_username"), SecurityConfigParameter.stringParam((String)"groupsClaimName", (String)"Groups Claim Name", (String)"groups"), SecurityConfigParameter.stringParam((String)"jwsAlgorithm", (String)"JWS Algorithm", (String)"RS256"), SecurityConfigParameter.stringParam((String)"userInfoRequestHttpMethod", (String)"User Info Request HTTP Method", (String)"GET"), SecurityConfigParameter.stringParam((String)"sendClientInfoInTokenRequest", (String)"Send Client Info in Token Request", (String)"false")), GroupsToRolesMappingConfig.CONFIG_PARAMETERS.stream()).toList(), "SAML", Stream.concat(Stream.of(SecurityConfigParameter.stringParam((String)"relyingPartyId", (String)"Relying Party Identifier"), SecurityConfigParameter.stringParam((String)"postBackUrl", (String)"Post Back URL"), SecurityConfigParameter.stringParam((String)"groupAttribute", (String)"Group Attribute"), SecurityConfigParameter.stringParam((String)"idpMetadata", (String)"Identity Provider Metadata"), SecurityConfigParameter.stringParam((String)"groupNameSeparator", (String)"Group Name Separator", (String)",")), GroupsToRolesMappingConfig.CONFIG_PARAMETERS.stream()).toList());

    public String getName();

    public void saveConfig(Map<String, String> var1);

    public AuthenticationProvider getAuthenticationProvider();

    default public List<SecurityConfigParameter> getConfigParameters() {
        return CONFIG_PARAMETERS.getOrDefault(this.getName(), Collections.emptyList());
    }

    default public Optional<String> testConfig(String testUsername, String testPassword, Map<String, String> parameters) {
        throw new UnsupportedOperationException("Testing security config is not supported for this provider: " + this.getName());
    }
}

