/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.prometheus;

import com.hazelcast.webmonitor.prometheus.EventReceiverProvider;
import com.hazelcast.webmonitor.prometheus.PrometheusEntry;
import com.hazelcast.webmonitor.service.healthcheck.HealthCheckStatusCountEvent;
import java.util.Map;

class HealthCheckStatusProvider
extends EventReceiverProvider<HealthCheckStatusCountEvent> {
    private static final int TTL_IN_SECONDS = 10;

    HealthCheckStatusProvider() {
        super(10);
    }

    void updateResults(HealthCheckStatusCountEvent event) {
        event.getHealthCheckCounts().forEach((clusterName, counts) -> counts.forEach((statusType, count) -> {
            String metricName = "healthcheck_status_" + statusType.name().toLowerCase();
            this.results.put((Object)new PrometheusEntry.Key(metricName, Map.of("mc_cluster", clusterName), "COUNT"), (Object)new PrometheusEntry.Value(event.getTime(), count.doubleValue()));
        }));
    }
}

