/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.model;

import com.hazelcast.webmonitor.model.ClientAttributes;
import com.hazelcast.webmonitor.model.ClientAttributesParsingResult;
import com.hazelcast.webmonitor.model.ClientAttributesUtil;
import com.hazelcast.webmonitor.model.InstanceType;
import com.hazelcast.webmonitor.model.hz.req.state.ClientEndPointDTO;
import com.hazelcast.webmonitor.model.hz.req.state.LocalWanPublisherStats;
import com.hazelcast.webmonitor.model.hz.req.state.MemberState;
import com.hazelcast.webmonitor.model.hz.req.state.TimedMemberState;
import com.hazelcast.webmonitor.utils.MemberMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.stream.Collectors;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
public class AllState {
    public static final String HZ_CACHE_PREFIX = "/hz/";
    private long time;
    private final Map<String, TimedMemberState> memberStateMap = new ConcurrentHashMap();
    private volatile SortedSet<String> members = new ConcurrentSkipListSet();
    private final EnumMap<InstanceType, SortedSet<String>> instanceNames = new EnumMap(InstanceType.class);

    public SortedSet<String> getInstanceNames(InstanceType type) {
        return this.instanceNames.computeIfAbsent(type, key -> new ConcurrentSkipListSet());
    }

    public Map<String, ClientEndPointDTO> getClients() {
        HashMap<String, ClientEndPointDTO> clients = new HashMap<String, ClientEndPointDTO>();
        for (TimedMemberState timedMemberState : this.memberStateMap.values()) {
            MemberState memberState = timedMemberState.getMemberState();
            for (ClientEndPointDTO clientInfo : memberState.getClients()) {
                clients.put(clientInfo.getAddress(), clientInfo);
            }
        }
        return clients;
    }

    public Map<String, List<ClientEndPointDTO>> getClientsPerMember() {
        HashMap<String, List<ClientEndPointDTO>> clients = new HashMap<String, List<ClientEndPointDTO>>();
        for (TimedMemberState timedMemberState : this.memberStateMap.values()) {
            MemberState memberState = timedMemberState.getMemberState();
            clients.put(memberState.getAddress(), new ArrayList());
            for (ClientEndPointDTO clientInfo : memberState.getClients()) {
                ((List)clients.get(memberState.getAddress())).add(clientInfo);
            }
        }
        return clients;
    }

    public Set<String> getMembersPerClientUuid(String uuid) {
        return this.memberStateMap.values().stream().map(TimedMemberState::getMemberState).filter(state -> state.getClients().stream().anyMatch(client -> client.getUuid().equals(uuid))).map(MemberState::getAddress).collect(Collectors.toCollection(TreeSet::new));
    }

    public Map<String, ClientEndPointDTO> getClientsPerUuid() {
        HashMap<String, ClientEndPointDTO> clients = new HashMap<String, ClientEndPointDTO>();
        for (TimedMemberState timedMemberState : this.memberStateMap.values()) {
            MemberState memberState = timedMemberState.getMemberState();
            for (ClientEndPointDTO clientInfo : memberState.getClients()) {
                if (clients.containsKey(clientInfo.getUuid()) && !Boolean.TRUE.equals(clientInfo.getStatsEnabled())) continue;
                clients.put(clientInfo.getUuid(), clientInfo);
            }
        }
        return clients;
    }

    public Map<String, ClientEndPointDTO> getStatsEnabledClients() {
        return this.getClientsPerUuid().entrySet().stream().filter(entry -> ((ClientEndPointDTO)entry.getValue()).getStatsEnabled()).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Set<String> getClientAddresses() {
        HashSet<String> clients = new HashSet<String>();
        for (TimedMemberState timedMemberState : this.memberStateMap.values()) {
            MemberState memberState = timedMemberState.getMemberState();
            for (ClientEndPointDTO clientInfo : memberState.getClients()) {
                clients.add(clientInfo.getAddress());
            }
        }
        return clients;
    }

    public Set<String> getInstanceWanPublisherSet(String scheme) {
        for (String member : this.members) {
            TimedMemberState memberState = (TimedMemberState)this.memberStateMap.get(member);
            if (!AllState.isWanStateAvailable((TimedMemberState)memberState, (String)scheme)) continue;
            return memberState.getMemberState().getLocalWanStats(scheme).getLocalWanPublisherStats().keySet();
        }
        return Collections.emptySet();
    }

    private static boolean isWanStateAvailable(TimedMemberState memberState, String scheme) {
        return memberState != null && memberState.getMemberState().getLocalWanStats(scheme) != null;
    }

    public MemberMap<TimedMemberState> getTimedMemberStates() {
        return com.hazelcast.webmonitor.utils.Collections.asMemberMap((Map)this.memberStateMap);
    }

    public Optional<MemberState> getRandomMemberState() {
        return this.memberStateMap.values().stream().map(TimedMemberState::getMemberState).findAny();
    }

    public Optional<MemberState> getMasterMemberState() {
        return this.memberStateMap.values().stream().filter(TimedMemberState::isMaster).findAny().map(TimedMemberState::getMemberState);
    }

    public MemberMap<MemberState> getMemberStates() {
        return com.hazelcast.webmonitor.utils.Collections.asMemberMap((Map)this.memberStateMap, TimedMemberState::getMemberState);
    }

    public void removeMemberState(String member) {
        this.memberStateMap.remove(member);
        this.initInstanceNames();
    }

    public SortedSet<String> getMembers() {
        return this.members;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public List<String> addState(TimedMemberState memberState) {
        if (memberState.isMaster()) {
            this.members = new ConcurrentSkipListSet(memberState.getMembers());
        }
        this.memberStateMap.put(memberState.getMemberState().getAddress(), memberState);
        this.addInstanceNames(memberState);
        return this.addClientAttributes(memberState);
    }

    private void initInstanceNames() {
        this.instanceNames.clear();
        for (TimedMemberState state : this.memberStateMap.values()) {
            this.addInstanceNames(state);
        }
    }

    private void addInstanceNames(TimedMemberState state) {
        for (InstanceType type : InstanceType.values()) {
            SortedSet names = this.getInstanceNames(type);
            if (type == InstanceType.CACHE) {
                for (String name : state.getMemberState().getInstanceNames(type)) {
                    names.add(name.startsWith("/hz/") ? name.substring("/hz/".length()) : name);
                }
                continue;
            }
            names.addAll(state.getMemberState().getInstanceNames(type));
        }
    }

    private List<String> addClientAttributes(TimedMemberState memberState) {
        ArrayList<String> errors = new ArrayList<String>();
        Map clientAttributes = memberState.getMemberState().getClientAttributes();
        if (clientAttributes == null || clientAttributes.isEmpty()) {
            return Collections.emptyList();
        }
        memberState.getMemberState().getClients().stream().filter(client -> clientAttributes.get(client.getUuid()) != null).forEach(client -> {
            String clientUuid = client.getUuid();
            String clientAttributesString = (String)clientAttributes.get(clientUuid);
            ClientAttributesParsingResult result = ClientAttributesUtil.parseClientAttributes((String)clientUuid, (String)clientAttributesString);
            ClientAttributes attrs = result.getClientAttributes();
            result.getParsingError().ifPresent(errors::add);
            client.setEnterprise(attrs.getEnterprise());
            client.setClusterConnectionTimestamp(attrs.getClusterConnectionTimestamp());
            client.setStatsEnabled(Boolean.valueOf(true));
            if (client.getClientVersion() == null) {
                client.setClientVersion(attrs.getVersion());
            }
        });
        return errors;
    }

    public Map<String, LocalWanPublisherStats> getWanPublisherData(String wanReplication, String publisher) {
        if (this.members == null) {
            return Collections.emptyMap();
        }
        HashMap<String, LocalWanPublisherStats> result = new HashMap<String, LocalWanPublisherStats>();
        for (String member : this.members) {
            TimedMemberState memberState = (TimedMemberState)this.memberStateMap.get(member);
            if (memberState == null || memberState.getMemberState().getLocalWanStats(wanReplication) == null || memberState.getMemberState().getLocalWanStats(wanReplication).getLocalWanPublisherStats().get(publisher) == null) continue;
            LocalWanPublisherStats publisherStats = (LocalWanPublisherStats)memberState.getMemberState().getLocalWanStats(wanReplication).getLocalWanPublisherStats().get(publisher);
            result.put(member, publisherStats);
        }
        return result;
    }

    public List<String> getUnsafeMembers() {
        ArrayList<String> unsafeMembers = new ArrayList<String>();
        for (String member : this.members) {
            TimedMemberState memberState = (TimedMemberState)this.memberStateMap.get(member);
            if (memberState == null || memberState.getMemberState().getMemberPartitionState().isMemberStateSafe()) continue;
            unsafeMembers.add(member);
        }
        return unsafeMembers;
    }

    public List<String> getCPMemberUuids() {
        return this.memberStateMap.values().stream().map(m -> m.getMemberState().getCpMemberUuid()).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public boolean isDataAccessEnabled() {
        return this.memberStateMap.values().stream().allMatch(TimedMemberState::getMcDataAccessEnabled);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "AllState(time=" + this.getTime() + ", memberStateMap=" + String.valueOf(this.memberStateMap) + ", members=" + String.valueOf(this.getMembers()) + ", instanceNames=" + String.valueOf(this.instanceNames) + ")";
    }
}

