/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics.impl.rocksdb;

import com.hazelcast.webmonitor.config.properties.MetricsConfigurationProperties;
import com.hazelcast.webmonitor.metrics.impl.rocksdb.RocksDBCompositeMetricsStorage;
import com.hazelcast.webmonitor.metrics.impl.rocksdb.RocksDBMetricsQueryService;
import com.hazelcast.webmonitor.metrics.impl.rocksdb.RocksDBMetricsStorageStatsCollector;
import com.hazelcast.webmonitor.metrics.impl.rocksdb.RocksDBMetricsStorageStatsCounter;
import com.hazelcast.webmonitor.metrics.impl.rocksdb.RocksDBMetricsStorageStatsLogger;
import com.hazelcast.webmonitor.metrics.impl.rocksdb.RocksDBMetricsStorageStatsSupplier;
import com.hazelcast.webmonitor.service.Clock;
import com.hazelcast.webmonitor.service.HomeDirectoryProvider;
import com.hazelcast.webmonitor.service.MemberManager;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(value={"hazelcast.mc.metrics.storageImpl"}, havingValue="RocksDB")
class RocksDBCompositeMetricsStorageConfiguration {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RocksDBCompositeMetricsStorageConfiguration.class);

    RocksDBCompositeMetricsStorageConfiguration() {
    }

    @Bean
    RocksDBCompositeMetricsStorage rocksDBCompositeMetricsStorage(HomeDirectoryProvider homeDirectoryProvider, MetricsConfigurationProperties metricsProperties, RocksDBMetricsStorageStatsCounter statsCounter, Clock clock) {
        return new RocksDBCompositeMetricsStorage(statsCounter, clock, homeDirectoryProvider, 10000, metricsProperties.getAccumulationPeriod(), metricsProperties.getDiskTtl());
    }

    @Bean
    RocksDBMetricsQueryService rocksDBMetricsQueryService(RocksDBCompositeMetricsStorage metricsStorage, MemberManager memberManager) {
        return new RocksDBMetricsQueryService(metricsStorage, memberManager);
    }

    @Bean
    RocksDBMetricsStorageStatsCounter rocksDbMetricsStorageStatsCounter() {
        return new RocksDBMetricsStorageStatsCounter();
    }

    @Bean
    RocksDBMetricsStorageStatsSupplier metricsStorageDiagnosticsSupplier(RocksDBCompositeMetricsStorage metricsStorage, MetricsConfigurationProperties metricsProperties, RocksDBMetricsStorageStatsCounter statsCounter) {
        return new RocksDBMetricsStorageStatsSupplier(metricsStorage, statsCounter, metricsProperties.getDiskTtl());
    }

    @Bean
    RocksDBMetricsStorageStatsLogger rocksDbMetricsStorageStatsLogger(RocksDBMetricsStorageStatsSupplier rocksDBMetricsStorageStatsSupplier) {
        return new RocksDBMetricsStorageStatsLogger(rocksDBMetricsStorageStatsSupplier);
    }

    @Bean
    @ConditionalOnProperty(name={"hazelcast.mc.phone.home.enabled"}, matchIfMissing=true)
    RocksDBMetricsStorageStatsCollector rocksDbMetricsStorageStatsCollector(RocksDBMetricsStorageStatsSupplier rocksDBMetricsStorageStatsSupplier) {
        return new RocksDBMetricsStorageStatsCollector(rocksDBMetricsStorageStatsSupplier);
    }
}

