/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics.impl.rocksdb;

import com.google.common.annotations.VisibleForTesting;
import com.hazelcast.webmonitor.metrics.impl.rocksdb.MinuteSeries;
import com.hazelcast.webmonitor.metrics.impl.rocksdb.MinuteStartId;
import com.hazelcast.webmonitor.metrics.impl.rocksdb.RawDataPoint;
import com.hazelcast.webmonitor.metrics.impl.rocksdb.RocksDBMetricsStorageStatsCounter;
import com.hazelcast.webmonitor.metrics.impl.rocksdb.RocksDBTimeUtil;
import com.hazelcast.webmonitor.metrics.utils.ValueUtil;
import com.hazelcast.webmonitor.utils.ExecutorServiceShutdownUtils;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

final class InMemoryCache
implements AutoCloseable {
    private static final int METRICS_GC_RATE_MINUTES = 5;
    private final ConcurrentMap<Integer, MinuteSeries> store;
    private final RocksDBMetricsStorageStatsCounter statsCounter;
    private final ScheduledExecutorService danglingMetricsGC = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "DanglingMetricsGC"));

    InMemoryCache(RocksDBMetricsStorageStatsCounter statsCounter, int initialSize) {
        this.statsCounter = statsCounter;
        this.store = new ConcurrentHashMap(initialSize);
        this.danglingMetricsGC.scheduleAtFixedRate(() -> this.cleanUpDanglingMetrics(), 5L, 5L, TimeUnit.MINUTES);
    }

    void cleanUpDanglingMetrics() {
        this.store.forEach((metricId, value) -> this.store.computeIfPresent(metricId, (k, v) -> {
            if (v.isEmpty()) {
                this.statsCounter.incrementEvictedDanglingMinuteSeries();
                return null;
            }
            return v;
        }));
    }

    MinuteSeries getMinuteSeries(int metricId) {
        return this.store.computeIfAbsent(metricId, MinuteSeries::new);
    }

    long[] get(MinuteStartId minStartId) {
        MinuteSeries minuteSeries = (MinuteSeries)this.store.get(minStartId.getMetricId());
        if (minuteSeries == null) {
            return null;
        }
        return minuteSeries.findValues(minStartId.getTime());
    }

    RawDataPoint getLatest(MinuteStartId minStartId, long endTime) {
        long[] values = this.get(minStartId);
        if (values != null) {
            for (int i = values.length - 1; i > -1; --i) {
                long time;
                long value = values[i];
                if (ValueUtil.isMissingValue((long)value) || (time = RocksDBTimeUtil.minuteTimePoint((long)minStartId.getTime(), (int)i)) > endTime) continue;
                return new RawDataPoint(RocksDBTimeUtil.minuteTimePoint((long)minStartId.getTime(), (int)i), value);
            }
        }
        return null;
    }

    @Override
    public void close() {
        ExecutorServiceShutdownUtils.shutdownExecutorService((ExecutorService)this.danglingMetricsGC);
    }

    @VisibleForTesting
    boolean containsMetricId(int metricId) {
        return this.store.containsKey(metricId);
    }
}

