/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics.impl.inmemory;

import com.hazelcast.webmonitor.controller.dto.metrics.BaseDataPointDTO;
import com.hazelcast.webmonitor.controller.dto.metrics.MetricDTO;
import com.hazelcast.webmonitor.metrics.AbstractMetricsQueryService;
import com.hazelcast.webmonitor.metrics.DataPointSeries;
import com.hazelcast.webmonitor.metrics.DataPointType;
import com.hazelcast.webmonitor.metrics.MetricsStorage;
import com.hazelcast.webmonitor.metrics.Query;
import com.hazelcast.webmonitor.metrics.aggregation.Aggregation;
import com.hazelcast.webmonitor.service.MemberManager;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
public class InMemoryMetricsQueryService
extends AbstractMetricsQueryService {
    private final MetricsStorage storage;
    private final MemberManager memberManager;

    private <D> List<D> serveRequest(String cluster, List<MetricDTO> metrics, long start, long end, AbstractMetricsQueryService.QuerySupplierFactory<D> querySupplierFactory) {
        List members = this.memberManager.getMemberList(cluster);
        ArrayList result = new ArrayList(metrics.size());
        Query.Builder queryBuilder = Query.builder();
        for (MetricDTO metric : metrics) {
            queryBuilder.reset().cluster(cluster).start(start).end(end);
            InMemoryMetricsQueryService.readFromMetricDTO((Query.Builder)queryBuilder, (MetricDTO)metric);
            result.add(querySupplierFactory.create(metric, queryBuilder, members, cluster, this.storage).get());
        }
        return result;
    }

    public List<List<BaseDataPointDTO>> queryRange(String cluster, List<MetricDTO> metrics, long start, long end) {
        return this.serveRequest(cluster, metrics, start, end, InMemoryMetricsQueryService::range);
    }

    public List<BaseDataPointDTO> queryLatest(String cluster, List<MetricDTO> metrics, long start, long end) {
        return this.serveRequest(cluster, metrics, start, end, InMemoryMetricsQueryService::latest);
    }

    private static Supplier<List<BaseDataPointDTO>> range(MetricDTO metric, Query.Builder queryBuilder, List<String> members, String cluster, MetricsStorage storage) {
        return () -> {
            Aggregation aggregation = Aggregation.create((MetricDTO.AggregateBy)metric.getAggregateBy(), (List)members, (String)cluster, (MetricsStorage)storage);
            MetricDTO.Aggregate aggregate = metric.getAggregate();
            DataPointSeries series = aggregation.range(queryBuilder, aggregate);
            AbstractMetricsQueryService.DataPointMapper mapper = InMemoryMetricsQueryService.determineMapper((MetricDTO.Aggregate)aggregate, (DataPointType)series.getType());
            return series.stream().map(arg_0 -> ((AbstractMetricsQueryService.DataPointMapper)mapper).map(arg_0)).collect(Collectors.toList());
        };
    }

    private static Supplier<BaseDataPointDTO> latest(MetricDTO metric, Query.Builder queryBuilder, List<String> members, String cluster, MetricsStorage storage) {
        return () -> {
            Aggregation aggregation = Aggregation.create((MetricDTO.AggregateBy)metric.getAggregateBy(), (List)members, (String)cluster, (MetricsStorage)storage);
            MetricDTO.Aggregate aggregate = metric.getAggregate();
            Optional latest = aggregation.latest(queryBuilder, aggregate);
            return latest.map(dataPoint -> {
                AbstractMetricsQueryService.DataPointMapper mapper = InMemoryMetricsQueryService.determineMapper((MetricDTO.Aggregate)aggregate, (DataPointType)dataPoint.getType());
                return mapper.map(dataPoint);
            }).orElse(null);
        };
    }

    @ConstructorProperties(value={"storage", "memberManager"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public InMemoryMetricsQueryService(MetricsStorage storage, MemberManager memberManager) {
        this.storage = storage;
        this.memberManager = memberManager;
    }
}

