/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics.imdg;

import com.hazelcast.webmonitor.metrics.Metric;
import com.hazelcast.webmonitor.metrics.Query;
import com.hazelcast.webmonitor.metrics.imdg.MemberMetricsQueryFactory;

public final class MemberMetricsQueryFactory {
    private final Query.Builder queryBuilder;

    public MemberMetricsQueryFactory(Builder builder) {
        this.queryBuilder = Query.builder().cluster(builder.cluster).member(builder.member).start(builder.start).end(builder.end);
    }

    public Query availableProcessorsQuery() {
        return this.queryBuilder.metric(Metric.RUNTIME_AVAILABLE_PROCESSORS).build();
    }

    public Query committedHeapQuery() {
        return this.queryBuilder.metric(Metric.MEMORY_COMMITTED_HEAP).build();
    }

    public Query usedHeapQuery() {
        return this.queryBuilder.metric(Metric.MEMORY_USED_HEAP).build();
    }

    public Query maxHeapQuery() {
        return this.queryBuilder.metric(Metric.MEMORY_MAX_HEAP).build();
    }

    public Query freeHeapQuery() {
        return this.queryBuilder.metric(Metric.MEMORY_FREE_HEAP).build();
    }

    public Query maxNativeQuery() {
        return this.queryBuilder.metric(Metric.MEMORY_MAX_NATIVE).build();
    }

    public Query committedNativeQuery() {
        return this.queryBuilder.metric(Metric.MEMORY_COMMITTED_NATIVE).build();
    }

    public Query usedNativeQuery() {
        return this.queryBuilder.metric(Metric.MEMORY_USED_NATIVE).build();
    }

    public Query freeNativeQuery() {
        return this.queryBuilder.metric(Metric.MEMORY_FREE_NATIVE).build();
    }

    public Query usedMetadataQuery() {
        return this.queryBuilder.metric(Metric.MEMORY_USED_METADATA).build();
    }

    public Query maxMetadataQuery() {
        return this.queryBuilder.metric(Metric.MEMORY_MAX_METADATA).build();
    }

    public Query gcMinorCount() {
        return this.queryBuilder.metric(Metric.GC_MINOR_COUNT).build();
    }

    public Query gcMinorTime() {
        return this.queryBuilder.metric(Metric.GC_MINOR_TIME).build();
    }

    public Query gcMajorCount() {
        return this.queryBuilder.metric(Metric.GC_MAJOR_COUNT).build();
    }

    public Query gcMajorTime() {
        return this.queryBuilder.metric(Metric.GC_MAJOR_TIME).build();
    }

    public Query processCpuLoad() {
        return this.queryBuilder.metric(Metric.OS_PROCESS_CPU_LOAD).build();
    }

    public Query systemCpuLoad() {
        return this.queryBuilder.metric(Metric.OS_SYSTEM_CPU_LOAD).build();
    }

    public Query systemLoadAverage() {
        return this.queryBuilder.metric(Metric.OS_SYSTEM_LOAD_AVERAGE).build();
    }

    public Query threadCount() {
        return this.queryBuilder.metric(Metric.THREAD_THREAD_COUNT).build();
    }

    public Query peakThreadCount() {
        return this.queryBuilder.metric(Metric.THREAD_PEAK_THREAD_COUNT).build();
    }

    public Query clientStartedInvocations() {
        return this.queryBuilder.metric(Metric.INVOCATIONS_STARTED_INVOCATIONS).build();
    }

    public Query operationQueueSize() {
        return this.queryBuilder.metric(Metric.OPERATION_QUEUE_SIZE).build();
    }

    public Query clusterUpTime() {
        return this.queryBuilder.metric(Metric.CLUSTER_CLOCK_CLUSTER_UP_TIME).build();
    }

    public Query clusterLastHeartbeat() {
        return this.queryBuilder.metric(Metric.CLUSTER_HEARTBEAT_LAST_HEARTBEAT).build();
    }
}

