/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics.imdg;

import com.hazelcast.webmonitor.metrics.Metric;
import com.hazelcast.webmonitor.metrics.Query;
import com.hazelcast.webmonitor.metrics.Tag;
import com.hazelcast.webmonitor.metrics.imdg.ClientNearCacheMetricsQueryFactory;
import com.hazelcast.webmonitor.model.InstanceType;
import java.util.EnumSet;

public final class ClientNearCacheMetricsQueryFactory {
    private static final EnumSet<InstanceType> ALLOWED_TYPES = EnumSet.of(InstanceType.MAP, InstanceType.CACHE);
    private final Query.Builder queryBuilder;
    private final InstanceType instanceType;

    private ClientNearCacheMetricsQueryFactory(Builder builder) {
        if (!ALLOWED_TYPES.contains(builder.instanceType)) {
            throw new IllegalArgumentException("ClientNearCacheMetricsQueryFactory can be instantiated for " + String.valueOf(ALLOWED_TYPES));
        }
        this.instanceType = builder.instanceType;
        this.queryBuilder = Query.builder().cluster(builder.cluster).client(builder.clientUuid).addTag(Tag.CLIENT_NAME, builder.clientName).addTag(Tag.NAME, this.fullName(builder.name)).start(builder.start).end(builder.end);
    }

    public Query hitsQuery() {
        return this.queryBuilder.metric(Metric.NEARCACHE_HITS).build();
    }

    public Query missesQuery() {
        return this.queryBuilder.metric(Metric.NEARCACHE_MISSES).build();
    }

    public Query creationTimeQuery() {
        return this.queryBuilder.metric(Metric.NEARCACHE_CREATION_TIME).build();
    }

    public Query evictionsQuery() {
        return this.queryBuilder.metric(Metric.NEARCACHE_EVICTIONS).build();
    }

    public Query expirationsQuery() {
        return this.queryBuilder.metric(Metric.NEARCACHE_EXPIRATIONS).build();
    }

    public Query ownedEntryCountQuery() {
        return this.queryBuilder.metric(Metric.NEARCACHE_OWNED_ENTRY_COUNT).build();
    }

    public Query ownedEntryMemoryCostQuery() {
        return this.queryBuilder.metric(Metric.NEARCACHE_OWNED_ENTRY_MEMORY_COST).build();
    }

    public Query lastPersistenceDurationQuery() {
        return this.queryBuilder.metric(Metric.NEARCACHE_LAST_PERSISTENCE_DURATION).build();
    }

    public Query lastPersistenceKeyCountQuery() {
        return this.queryBuilder.metric(Metric.NEARCACHE_LAST_PERSISTENCE_KEY_COUNT).build();
    }

    public Query lastPersistenceTimeQuery() {
        return this.queryBuilder.metric(Metric.NEARCACHE_LAST_PERSISTENCE_TIME).build();
    }

    public Query lastPersistenceWrittenBytesQuery() {
        return this.queryBuilder.metric(Metric.NEARCACHE_LAST_PERSISTENCE_WRITTEN_BYTES).build();
    }

    private String fullName(String name) {
        if (this.instanceType == InstanceType.CACHE) {
            return "/hz/" + name;
        }
        return name;
    }
}

