/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics.imdg;

import com.hazelcast.webmonitor.metrics.Metric;
import com.hazelcast.webmonitor.metrics.Query;
import com.hazelcast.webmonitor.metrics.Tag;
import com.hazelcast.webmonitor.metrics.imdg.ClientMetricsQueryFactory;

public final class ClientMetricsQueryFactory {
    private final Query.Builder queryBuilder;

    private ClientMetricsQueryFactory(Builder builder) {
        this.queryBuilder = Query.builder().cluster(builder.cluster).client(builder.clientUuid).addTag(Tag.CLIENT_NAME, builder.clientName).start(builder.start).end(builder.end);
    }

    public Query committedVirtualMemorySizeQuery() {
        return this.queryBuilder.metric(Metric.OS_COMMITTED_VIRTUAL_MEMORY_SIZE).build();
    }

    public Query freePhysicalMemorySizeQuery() {
        return this.queryBuilder.metric(Metric.OS_FREE_PHYSICAL_MEMORY_SIZE).build();
    }

    public Query freeSwapSpaceSizeQuery() {
        return this.queryBuilder.metric(Metric.OS_FREE_SWAP_SPACE_SIZE).build();
    }

    public Query maxFileDescriptorCountQuery() {
        return this.queryBuilder.metric(Metric.OS_MAX_FILE_DESCRIPTOR_COUNT).build();
    }

    public Query openFileDescriptorCountQuery() {
        return this.queryBuilder.metric(Metric.OS_OPEN_FILE_DESCRIPTOR_COUNT).build();
    }

    public Query processCpuTimeQuery() {
        return this.queryBuilder.metric(Metric.OS_PROCESS_CPU_TIME).build();
    }

    public Query systemLoadAverageQuery() {
        return this.queryBuilder.metric(Metric.OS_SYSTEM_LOAD_AVERAGE).build();
    }

    public Query totalPhysicalMemorySizeQuery() {
        return this.queryBuilder.metric(Metric.OS_TOTAL_PHYSICAL_MEMORY_SIZE).build();
    }

    public Query totalSwapSpaceSizeQuery() {
        return this.queryBuilder.metric(Metric.OS_TOTAL_SWAP_SPACE_SIZE).build();
    }

    public Query availableProcessorsQuery() {
        return this.queryBuilder.metric(Metric.RUNTIME_AVAILABLE_PROCESSORS).build();
    }

    public Query freeMemoryQuery() {
        return this.queryBuilder.metric(Metric.RUNTIME_FREE_MEMORY).build();
    }

    public Query maxMemoryQuery() {
        return this.queryBuilder.metric(Metric.RUNTIME_MAX_MEMORY).build();
    }

    public Query totalMemoryQuery() {
        return this.queryBuilder.metric(Metric.RUNTIME_TOTAL_MEMORY).build();
    }

    public Query usedMemoryQuery() {
        return this.queryBuilder.metric(Metric.RUNTIME_USED_MEMORY).build();
    }

    public Query uptimeQuery() {
        return this.queryBuilder.metric(Metric.RUNTIME_UPTIME).build();
    }
}

