/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics.aggregation;

import com.hazelcast.webmonitor.metrics.DataPointAware;
import com.hazelcast.webmonitor.metrics.DataPointSeries;
import com.hazelcast.webmonitor.metrics.DataPointType;
import com.hazelcast.webmonitor.metrics.aggregation.AggregateMetricsUtil;
import com.hazelcast.webmonitor.metrics.aggregation.Aggregator;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GroupByAggregator
implements Aggregator {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GroupByAggregator.class);
    protected final List<DataPointSeries> aggregatedSeries = new ArrayList();
    private long startTime = Long.MAX_VALUE;
    private long endTime = Long.MIN_VALUE;
    protected DataPointType dataPointType;

    public void add(DataPointSeries series) {
        if (series.isEmpty()) {
            return;
        }
        if (this.dataPointType == null) {
            this.dataPointType = series.getType();
        }
        if (series.getType() != this.dataPointType) {
            throw new IllegalArgumentException("Added series has incompatible type with aggregated. Expected: " + String.valueOf(this.dataPointType) + " was: " + String.valueOf(series.getType()));
        }
        DataPointAware firstPoint = (DataPointAware)series.getEarliestDataPoint().orElseThrow(IllegalStateException::new);
        DataPointAware lastPoint = (DataPointAware)series.getLatestDataPoint().orElseThrow(IllegalStateException::new);
        if (firstPoint.getTime() < this.startTime) {
            this.startTime = firstPoint.getTime();
        }
        if (lastPoint.getTime() > this.endTime) {
            this.endTime = lastPoint.getTime();
        }
        this.aggregatedSeries.add(series);
    }

    protected long[] unionTimePoints() {
        int secondsInRange = (int)((this.endTime - this.startTime) / 1000L) + 1;
        boolean[] usedTimePoints = new boolean[secondsInRange];
        int secondsInAggregate = 0;
        for (DataPointSeries series : this.aggregatedSeries) {
            for (DataPointAware point : series) {
                int indexInSet = (int)(point.getTime() - this.startTime) / 1000;
                if (usedTimePoints[indexInSet]) continue;
                usedTimePoints[indexInSet] = true;
                ++secondsInAggregate;
            }
        }
        long[] timePoints = new long[secondsInAggregate];
        int timePointsPtr = 0;
        for (int i = 0; i < usedTimePoints.length; ++i) {
            if (!usedTimePoints[i]) continue;
            timePoints[timePointsPtr++] = this.startTime + (long)i * 1000L;
        }
        return timePoints;
    }

    protected void combineSeries(DataPointSeries series, long[] times, long[] dest) {
        Iterator iter = series.iterator();
        DataPointAware point = (DataPointAware)iter.next();
        DataPointAware prevPoint = null;
        for (int i = 0; i < times.length; ++i) {
            while (iter.hasNext() && point.getTime() < times[i]) {
                prevPoint = point;
                point = (DataPointAware)iter.next();
            }
            if (prevPoint == null) {
                this.combinePoint(dest, i, point.getValue());
                continue;
            }
            if (!iter.hasNext() && times[i] >= point.getTime()) {
                this.combinePoint(dest, i, point.getValue());
                continue;
            }
            this.combinePoint(dest, i, AggregateMetricsUtil.interpolate((long)times[i], (DataPointAware)prevPoint, (DataPointAware)point));
        }
    }

    protected abstract void combinePoint(long[] var1, int var2, long var3);
}

