/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics;

import com.fasterxml.jackson.annotation.JsonValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
public enum Tag {
    METRIC("metric"),
    MEMBER("mc_member"),
    CLIENT("mc_client"),
    NAME("name"),
    CLIENT_NAME("clientname"),
    INDEX("index"),
    ENDPOINT("endpoint"),
    PUBLISHER_ID("publisherId"),
    REPLICATION("replication"),
    ENDPOINT_NAME("endpointName", false),
    ENDPOINT_TYPE("endpointType", false),
    ROLE("role", false),
    GROUP_ID("groupId", false),
    SESSION_ID("sessionId", false),
    GROUP("group", false),
    ID("id", false);

    private final String name;
    private final boolean persisted;
    static final Map<String, Tag> NAME_TO_VALUE_MAP;
    static final Set<String> PERSISTED_TAG_NAMES_AS_SET;

    private Tag(String name) {
        this(string, n, name, true);
    }

    private Tag(String name, boolean persisted) {
        this.name = name;
        this.persisted = persisted;
    }

    @Nonnull
    public static Tag forName(String name) {
        Tag tag = (Tag)NAME_TO_VALUE_MAP.get(name);
        if (tag == null) {
            throw new NoSuchElementException("There is no Tag with name = " + name);
        }
        return tag;
    }

    public static boolean isPersisted(String name) {
        return PERSISTED_TAG_NAMES_AS_SET.contains(name);
    }

    @JsonValue
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getName() {
        return this.name;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isPersisted() {
        return this.persisted;
    }

    static {
        NAME_TO_VALUE_MAP = Arrays.stream(Tag.values()).collect(Collectors.toMap(Tag::getName, Function.identity()));
        PERSISTED_TAG_NAMES_AS_SET = NAME_TO_VALUE_MAP.values().stream().filter(Tag::isPersisted).map(Tag::getName).collect(Collectors.toSet());
    }
}

