/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics;

import com.hazelcast.internal.util.BiTuple;
import com.hazelcast.webmonitor.controller.dto.metrics.MetricsDebugDataDTO;
import com.hazelcast.webmonitor.metrics.Metric;
import com.hazelcast.webmonitor.metrics.MetricDataPoint;
import com.hazelcast.webmonitor.metrics.MetricDataPointProcessor;
import com.hazelcast.webmonitor.metrics.MetricsStorage;
import com.hazelcast.webmonitor.service.HomeDirectoryProvider;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.healthcheck.PercentageUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.io.File;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class MetricsDebuggerService
implements MetricDataPointProcessor {
    private final AtomicBoolean samplingEnabled = new AtomicBoolean();
    private final AtomicLong totalDataPoints = new AtomicLong(0L);
    private final AtomicLong skippedDataPoints = new AtomicLong();
    private final ConcurrentMap<String, LongAdder> freqMap = new ConcurrentHashMap();
    private final HomeDirectoryProvider homeDirectoryProvider;
    private final MetricsStorage metricsStorage;

    public boolean shouldProcessDataPoint(MetricDataPoint dataPoint) {
        return this.samplingEnabled.get();
    }

    public void processDataPoint(MetricDataPoint dataPoint, MemberIdentifier memberIdent) {
        this.totalDataPoints.getAndIncrement();
        String metricName = dataPoint.getName();
        this.freqMap.computeIfAbsent(metricName, k -> new LongAdder()).increment();
        if (!Metric.isPersistent((String)metricName)) {
            this.skippedDataPoints.getAndAdd(1L);
        }
    }

    public void startSampling() {
        this.samplingEnabled.set(true);
    }

    public void stopSampling() {
        this.samplingEnabled.set(false);
        this.freqMap.clear();
        this.totalDataPoints.set(0L);
        this.skippedDataPoints.set(0L);
    }

    public MetricsDebugDataDTO dumpStatus() {
        Comparator<Map.Entry> byCount = Comparator.comparingLong(e -> ((LongAdder)e.getValue()).longValue()).reversed();
        List fm = this.freqMap.entrySet().stream().sorted(byCount).map(k -> BiTuple.of((Object)((String)k.getKey()), (Object)String.format("%s (persisted: %s)", k.getValue(), Metric.isPersistent((String)((String)k.getKey())) ? "yes" : "no"))).collect(Collectors.toList());
        long diskFree = new File(this.homeDirectoryProvider.get().toString()).getUsableSpace();
        double optimizationRatio = PercentageUtils.calculatePercentage((long)this.skippedDataPoints.get(), (long)this.totalDataPoints.get());
        return MetricsDebugDataDTO.builder().diskFreeSpace(diskFree).diskUsedSpaceByMetrics(this.metricsStorage.calculateDiskSize()).frequencyMap(fm).distinctMetrics((long)this.freqMap.size()).samplingEnabled(this.samplingEnabled.get()).optimizationRatio(optimizationRatio).totalDataPoints(this.totalDataPoints.get()).build();
    }

    @ConstructorProperties(value={"homeDirectoryProvider", "metricsStorage"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public MetricsDebuggerService(HomeDirectoryProvider homeDirectoryProvider, MetricsStorage metricsStorage) {
        this.homeDirectoryProvider = homeDirectoryProvider;
        this.metricsStorage = metricsStorage;
    }
}

