/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.events;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.hazelcast.webmonitor.events.EventPublishingVisitor;
import com.hazelcast.webmonitor.events.EventVisitor;
import com.hazelcast.webmonitor.events.model.AbstractEvent;
import com.hazelcast.webmonitor.events.model.DiagnosticsConfigUpdatedEvent;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class DiagnosticsConfigUpdatedEventStore {
    private static final int DIAGNOSTIC_CONFIG_EVENTS_MAX_CACHE_SIZE = 1000;
    private final EventPublishingVisitor eventPublishingVisitor;
    private final Cache<String, List<DiagnosticsConfigUpdatedEvent>> eventsByCluster = Caffeine.newBuilder().maximumSize(1000L).build();

    public void store(List<DiagnosticsConfigUpdatedEvent> incomingEvents) {
        Map<String, List<DiagnosticsConfigUpdatedEvent>> groupedIncomingEvents = incomingEvents.stream().collect(Collectors.groupingBy(DiagnosticsConfigUpdatedEvent::getClusterName));
        groupedIncomingEvents.forEach((clusterName, events) -> ((List)this.eventsByCluster.get(clusterName, __ -> new CopyOnWriteArrayList())).addAll(events));
        groupedIncomingEvents.values().stream().map(events -> (DiagnosticsConfigUpdatedEvent)events.get(events.size() - 1)).forEach(lastEvent -> lastEvent.accept((EventVisitor)this.eventPublishingVisitor));
    }

    public List<DiagnosticsConfigUpdatedEvent> findEventsByCluster(String clusterName) {
        List knownEvents = (List)this.eventsByCluster.getIfPresent((Object)clusterName);
        return knownEvents == null ? Collections.emptyList() : knownEvents;
    }

    public Optional<DiagnosticsConfigUpdatedEvent> findLastEventByState(String clusterName, boolean enabled) {
        List knownEvents = (List)this.eventsByCluster.getIfPresent((Object)clusterName);
        if (knownEvents == null) {
            return Optional.empty();
        }
        return knownEvents.stream().filter(event -> event.isEnabled() == enabled).max(Comparator.comparing(AbstractEvent::getTimestamp));
    }

    @ConstructorProperties(value={"eventPublishingVisitor"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DiagnosticsConfigUpdatedEventStore(EventPublishingVisitor eventPublishingVisitor) {
        this.eventPublishingVisitor = eventPublishingVisitor;
    }
}

