/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.controller.internal;

import com.hazelcast.webmonitor.auditlog.AuditLogService;
import com.hazelcast.webmonitor.controller.internal.BaseInternalController;
import com.hazelcast.webmonitor.controller.internal.HotRestartController;
import com.hazelcast.webmonitor.model.AllState;
import com.hazelcast.webmonitor.service.HotRestartManager;
import com.hazelcast.webmonitor.service.StateManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/api"})
public class HotRestartController
extends BaseInternalController {
    private final HotRestartManager hotRestartManager;

    @Autowired
    public HotRestartController(StateManager stateManager, HotRestartManager hotRestartManager, AuditLogService auditService) {
        super(stateManager, auditService);
        this.hotRestartManager = hotRestartManager;
    }

    @GetMapping(path={"/clusters/{cluster}/hotBackup"})
    public HotBackupStatus hotBackupStatus(@PathVariable(value="cluster") String cluster) {
        return new HotBackupStatus(this.getState(cluster).getMemberStates());
    }

    @GetMapping(path={"/clusters/{cluster}/hotRestart"})
    public HotRestartStatus hotRestartStatus(@PathVariable String cluster) {
        AllState state = this.getState(cluster);
        return state.getMasterMemberState().map(ms -> new HotRestartStatus(ms.getClusterHotRestartStatus())).orElse(null);
    }

    @PostMapping(path={"/clusters/{cluster}/forceStart"})
    @Secured(value={"ROLE_ADMIN"})
    public void forceStart(@PathVariable String cluster) {
        this.executeOperation(() -> this.hotRestartManager.triggerForceStart(cluster), this.operationLogBuilder("MC-6001 [Hot Restart]", "Run Force Start").parameter("cluster", (Object)cluster));
    }

    @PostMapping(path={"/clusters/{cluster}/partialStart"})
    @Secured(value={"ROLE_ADMIN"})
    public void partialStart(@PathVariable String cluster) {
        this.executeOperation(() -> this.hotRestartManager.triggerPartialStart(cluster), this.operationLogBuilder("MC-6002 [Hot Restart]", "Run Partial Start").parameter("cluster", (Object)cluster));
    }

    @PostMapping(path={"/clusters/{cluster}/hotBackup"})
    @Secured(value={"ROLE_ADMIN"})
    public void triggerHotBackup(@PathVariable String cluster) {
        this.executeOperation(() -> this.hotRestartManager.triggerHotRestartBackup(cluster), this.operationLogBuilder("MC-6003 [Hot Restart]", "Run Hot Backup").parameter("cluster", (Object)cluster));
    }

    @PostMapping(path={"/clusters/{cluster}/interruptHotBackup"})
    @Secured(value={"ROLE_ADMIN"})
    public void interruptHotBackup(@PathVariable String cluster) {
        this.executeOperation(() -> this.hotRestartManager.interruptHotRestartBackup(cluster), this.operationLogBuilder("MC-6004 [Hot Restart]", "Interrupt Hot Backup").parameter("cluster", (Object)cluster));
    }
}

