/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.console.rest;

import com.hazelcast.webmonitor.console.ConsoleManager;
import com.hazelcast.webmonitor.console.dto.ConsoleLaunchDTO;
import com.hazelcast.webmonitor.console.dto.KeyPressDTO;
import com.hazelcast.webmonitor.utils.SecurityContextUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.springframework.messaging.handler.annotation.DestinationVariable;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/api"})
@Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_CLOUD_USER"})
public class ConsoleController {
    private final ConsoleManager consoleManager;

    @GetMapping(value={"/clusters/{cluster}/console"})
    public ConsoleLaunchDTO startConsole(@PathVariable String cluster) {
        return this.consoleManager.start(cluster, SecurityContextUtil.getUsername());
    }

    @MessageMapping(value={"/console/{uuid}"})
    public void pipe(@DestinationVariable String uuid, @Payload KeyPressDTO input) {
        this.consoleManager.pipe(uuid, input.getKey());
    }

    @ConstructorProperties(value={"consoleManager"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ConsoleController(ConsoleManager consoleManager) {
        this.consoleManager = consoleManager;
    }
}

