/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.console;

import com.hazelcast.webmonitor.console.Console;
import com.hazelcast.webmonitor.console.ConsoleIOProcessor;
import com.hazelcast.webmonitor.websocket.event.SessionDisconnectedEvent;
import com.hazelcast.webmonitor.websocket.event.SessionSubscribedEvent;
import com.hazelcast.webmonitor.websocket.event.SessionUnsubscribedEvent;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.io.InputStream;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.messaging.Message;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.messaging.simp.stomp.StompHeaderAccessor;
import org.springframework.stereotype.Service;

@Service
public class ConsoleRequestProcessor {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConsoleRequestProcessor.class);
    public static final String USER_TOPIC_CONSOLE_RESULTS = "/user/topic/console/";
    private final ConcurrentMap<String, ConsoleIOProcessor> processors = new ConcurrentHashMap();
    private final ConcurrentMap<String, Console> consoles = new ConcurrentHashMap();
    private final ConcurrentMap<String, Set<String>> sessionConsoleUuid = new ConcurrentHashMap();
    private final SimpMessagingTemplate messagingTemplate;

    public void addConsoleInstance(String username, Console console) {
        InputStream inputStream = console.getProcess().getInputStream();
        this.processors.put(console.getUuid(), new ConsoleIOProcessor(this.messagingTemplate, inputStream, username, console.getUuid()));
        this.consoles.put(console.getUuid(), console);
    }

    public void pipe(String consoleUuid, String key) {
        Console console = (Console)this.consoles.get(consoleUuid);
        if (console != null) {
            console.write(key);
        }
    }

    @EventListener
    public void onSessionUnsubscribed(SessionUnsubscribedEvent event) {
        StompHeaderAccessor accessor = StompHeaderAccessor.wrap((Message)event.getMessage());
        String destination = accessor.getFirstNativeHeader("simpOrigDestination");
        if (destination != null && destination.startsWith(USER_TOPIC_CONSOLE_RESULTS)) {
            String consoleUuid = destination.substring(destination.lastIndexOf(47) + 1);
            String subscriptionId = accessor.getSubscriptionId();
            String sessionId = accessor.getSessionId();
            log.debug("Unsubscribed: consoleUuid = {} subscriptionId = {} sessionId = {}", new Object[]{consoleUuid, subscriptionId, sessionId});
            this.sessionConsoleUuid.computeIfPresent(sessionId, (k, v) -> {
                if (v.remove(consoleUuid)) {
                    this.destroyConsole(consoleUuid);
                }
                return v;
            });
        }
    }

    @EventListener
    public void onSessionDisconnected(SessionDisconnectedEvent event) {
        String sessionId = event.getSessionId();
        this.sessionConsoleUuid.computeIfPresent(sessionId, (k, consoleUuids) -> {
            consoleUuids.forEach(arg_0 -> this.destroyConsole(arg_0));
            return null;
        });
        log.debug("Disconnected: sessionId = {}", (Object)sessionId);
    }

    @EventListener
    public void onSessionSubscribed(SessionSubscribedEvent event) {
        StompHeaderAccessor accessor = StompHeaderAccessor.wrap((Message)event.getMessage());
        String destination = accessor.getFirstNativeHeader("simpOrigDestination");
        if (destination != null && destination.startsWith(USER_TOPIC_CONSOLE_RESULTS)) {
            String consoleUuid = destination.substring(destination.lastIndexOf(47) + 1);
            String subscriptionId = accessor.getSubscriptionId();
            String sessionId = accessor.getSessionId();
            log.debug("Subscribed: consoleUuid = {} subscriptionId = {} sessionId = {}", new Object[]{consoleUuid, subscriptionId, sessionId});
            this.processors.computeIfPresent(consoleUuid, (key, processor) -> {
                this.sessionConsoleUuid.computeIfAbsent(sessionId, id -> Collections.newSetFromMap(new ConcurrentHashMap())).add(consoleUuid);
                processor.schedule();
                return processor;
            });
        }
    }

    void destroyConsole(String consoleUuid) {
        ConsoleIOProcessor processor = (ConsoleIOProcessor)this.processors.remove(consoleUuid);
        Console console = (Console)this.consoles.remove(consoleUuid);
        try {
            console.destroy();
            processor.close();
        }
        catch (Exception e) {
            log.warn("Failed to destroy console instance {} ", (Object)console.getUuid());
        }
    }

    Integer getActiveConsoleCount() {
        assert (this.consoles.size() == this.processors.size());
        return this.consoles.size();
    }

    ConsoleIOProcessor getIOProcessor(String uuid) {
        return (ConsoleIOProcessor)this.processors.get(uuid);
    }

    Integer getSessionConsoleCount(String sessionId) {
        Set sessionUuids = (Set)this.sessionConsoleUuid.get(sessionId);
        if (sessionUuids == null) {
            return 0;
        }
        return sessionUuids.size();
    }

    @ConstructorProperties(value={"messagingTemplate"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ConsoleRequestProcessor(SimpMessagingTemplate messagingTemplate) {
        this.messagingTemplate = messagingTemplate;
    }
}

