/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.config.properties;

import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.webmonitor.model.hz.req.state.Version;
import com.hazelcast.webmonitor.utils.PlatformUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BuildInfo {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BuildInfo.class);
    private static final String PROPERTIES_RESOURCE = "/mc.properties";
    private static String fullVersion;
    private static String hazelcastClientVersion;
    private static String jettyVersion;
    private static String consoleVersion;
    private static String revision;
    private static String buildTimestamp;
    private static boolean dockerEnv;
    private static String branding;

    private BuildInfo() {
    }

    public static String getFullVersion() {
        return fullVersion;
    }

    public static String getVersionForDocs() {
        Version version = Version.of((String)fullVersion);
        return version.toShortFormat() + (version.getQualifier() == null ? "" : version.getQualifier());
    }

    public static String getJettyVersion() {
        return jettyVersion;
    }

    public static String getHazelcastClientVersion() {
        return hazelcastClientVersion;
    }

    public static String getRevision() {
        return revision;
    }

    public static String getBuildTimestamp() {
        return buildTimestamp;
    }

    public static String getConsoleVersion() {
        return consoleVersion;
    }

    public static boolean isDockerEnv() {
        return dockerEnv;
    }

    public static String getBranding() {
        return branding;
    }

    static {
        Properties properties = new Properties();
        try (InputStream propertiesStream = BuildInfo.class.getResourceAsStream(PROPERTIES_RESOURCE);){
            if (propertiesStream == null) {
                throw new IOException(String.format("Could not find %s", PROPERTIES_RESOURCE));
            }
            properties.load(propertiesStream);
            fullVersion = properties.getProperty("mc.version", "invalid");
            revision = properties.getProperty("revision");
            buildTimestamp = properties.getProperty("build");
            consoleVersion = properties.getProperty("clc.version");
            hazelcastClientVersion = BuildInfoProvider.getBuildInfo().getVersion();
            jettyVersion = properties.getProperty("jetty.version");
            dockerEnv = PlatformUtil.isDockerEnv();
            branding = properties.getProperty("branding");
        }
        catch (Exception e) {
            log.error("Cannot load BuildInfo!", (Throwable)e);
        }
    }
}

