/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.config;

import com.google.common.collect.ImmutableList;
import com.hazelcast.webmonitor.config.conditions.ConditionalOnBranding;
import com.hazelcast.webmonitor.config.properties.FlowConfigurationProperties;
import com.hazelcast.webmonitor.security.spi.FlowRole;
import com.hazelcast.webmonitor.utils.SecurityContextUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.server.authorization.OAuth2TokenType;
import org.springframework.security.oauth2.server.authorization.client.InMemoryRegisteredClientRepository;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.security.oauth2.server.authorization.settings.ClientSettings;
import org.springframework.security.oauth2.server.authorization.settings.TokenSettings;
import org.springframework.security.oauth2.server.authorization.token.JwtEncodingContext;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenCustomizer;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;

/*
 * Exception performing whole class analysis ignored.
 */
@Configuration
@ConditionalOnBranding(value="flow")
public class SpringAuthorizationServerConfig {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpringAuthorizationServerConfig.class);
    public static final int FLOW_CLIENT_ID_TOKEN_DURATION_MINUTES = 30;
    private static final int FLOW_CLIENT_ACCESS_TOKEN_DURATION_SECONDS = 90;
    private static final int APPLICATION_CLIENT_ACCESS_TOKEN_DURATION_MINUTES = 60;
    private final FlowConfigurationProperties flowConfigurationProperties;
    @Value(value="${hazelcast.mc.application.client.secret:#{null}}")
    private String applicationClientSecret;

    UrlBasedCorsConfigurationSource corsConfigurationSource() {
        CorsConfiguration configuration = new CorsConfiguration();
        configuration.setAllowedOriginPatterns((List)this.buildFlowAllowList());
        configuration.setAllowedMethods(List.of("GET", "POST"));
        UrlBasedCorsConfigurationSource configurationSource = new UrlBasedCorsConfigurationSource();
        configurationSource.registerCorsConfiguration("/**", configuration);
        return configurationSource;
    }

    @NotNull
    private ImmutableList<String> buildFlowAllowList() {
        ImmutableList.Builder allowedOriginPatterns = ImmutableList.builder().add((Object)"http://localhost:9021").add((Object)"http://localhost:9021/silent-refresh.html").add((Object)"http://127.0.0.1:9021").add((Object)"http://127.0.0.1:9021/silent-refresh.html").add((Object)"http://localhost:9022").add((Object)"http://localhost:9022/silent-refresh.html").add((Object)"http://127.0.0.1:9022").add((Object)"http://127.0.0.1:9022/silent-refresh.html");
        this.flowConfigurationProperties.getAddresses().forEach(address -> allowedOriginPatterns.add(address).add((Object)(address + "/silent-refresh.html")));
        return allowedOriginPatterns.build();
    }

    @Bean
    public OAuth2TokenCustomizer<JwtEncodingContext> tokenCustomizer() {
        return context -> {
            if (OAuth2TokenType.ACCESS_TOKEN.equals((Object)context.getTokenType())) {
                context.getClaims().claims(claims -> {
                    claims.put("preferred_username", claims.get("sub"));
                    claims.put("clientId", SecurityContextUtil.getUsername());
                    if (context.getAuthorizationGrantType().equals((Object)AuthorizationGrantType.CLIENT_CREDENTIALS)) {
                        SpringAuthorizationServerConfig.putRolesToClaims((Map)claims, (List)SpringAuthorizationServerConfig.extractRolesForClientCredentials((Set)context.getAuthorizedScopes()));
                    } else {
                        SpringAuthorizationServerConfig.putRolesToClaims((Map)claims, (List)SpringAuthorizationServerConfig.extractRolesForAuthorizationCode((Authentication)context.getPrincipal()));
                    }
                });
            }
        };
    }

    @NotNull
    private static List<String> extractRolesForClientCredentials(Set<String> authorizedScopes) {
        return authorizedScopes.stream().filter(authorizedScope -> authorizedScope.startsWith("flow:")).map(authorizedScope -> authorizedScope.substring("flow:".length())).toList();
    }

    private static void putRolesToClaims(Map<String, Object> claims, List<String> roles) {
        if (roles.isEmpty()) {
            log.warn("Role didn't match with any existing roles, mapping it to Admin.");
            claims.put("roles", List.of(FlowRole.Admin.name()));
        } else {
            claims.put("roles", roles);
        }
    }

    private static List<String> extractRolesForAuthorizationCode(Authentication principal) {
        List<String> roles = principal.getAuthorities().stream().map(GrantedAuthority::getAuthority).toList();
        if (roles.contains("ROLE_ADMIN")) {
            return List.of(FlowRole.Admin.name());
        }
        if (roles.contains("ROLE_USER")) {
            return List.of(FlowRole.PlatformManager.name(), FlowRole.QueryRunner.name(), FlowRole.Viewer.name());
        }
        if (roles.contains("ROLE_READONLY_USER")) {
            return List.of(FlowRole.Viewer.name());
        }
        if (roles.contains("ROLE_METRICS_ONLY")) {
            return List.of(FlowRole.MetricsViewer.name());
        }
        return List.of();
    }

    @Bean
    public RegisteredClientRepository registeredClientRepository() {
        ArrayList<RegisteredClient> registrations = new ArrayList<RegisteredClient>();
        RegisteredClient flowClient = RegisteredClient.withId((String)"flow-client").clientId("flow-client").clientAuthenticationMethod(ClientAuthenticationMethod.NONE).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).authorizationGrantType(AuthorizationGrantType.REFRESH_TOKEN).redirectUris(redirectUris -> redirectUris.addAll(this.buildFlowAllowList())).scope("openid").scope("profile").scope("email").clientSettings(ClientSettings.builder().requireProofKey(true).requireAuthorizationConsent(false).build()).tokenSettings(TokenSettings.builder().accessTokenTimeToLive(Duration.ofSeconds(90L)).build()).build();
        registrations.add(flowClient);
        if (this.applicationClientSecret != null) {
            RegisteredClient applicationClient = RegisteredClient.withId((String)"application-client").clientId("application-client").clientAuthenticationMethod(ClientAuthenticationMethod.CLIENT_SECRET_BASIC).clientSecret("{noop}" + this.applicationClientSecret).authorizationGrantType(AuthorizationGrantType.CLIENT_CREDENTIALS).scope("openid").scope("profile").scope("email").scope("ROLE_ADMIN").scope("flow:" + FlowRole.Admin.name()).scope("flow:" + FlowRole.PlatformManager.name()).scope("flow:" + FlowRole.QueryRunner.name()).scope("flow:" + FlowRole.Viewer.name()).scope("flow:" + FlowRole.MetricsViewer.name()).tokenSettings(TokenSettings.builder().accessTokenTimeToLive(Duration.ofMinutes(60L)).build()).build();
            registrations.add(applicationClient);
        }
        return new InMemoryRegisteredClientRepository(registrations);
    }

    @ConstructorProperties(value={"flowConfigurationProperties"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SpringAuthorizationServerConfig(FlowConfigurationProperties flowConfigurationProperties) {
        this.flowConfigurationProperties = flowConfigurationProperties;
    }
}

