/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.cli;

import com.hazelcast.webmonitor.cli.BaseCliTask;
import com.hazelcast.webmonitor.cli.CliException;
import com.hazelcast.webmonitor.cli.KeystoreOptions;
import com.hazelcast.webmonitor.utils.KeystoreUtil;
import com.hazelcast.webmonitor.utils.StringUtil;
import java.io.PrintWriter;
import org.springframework.core.env.ConfigurableEnvironment;
import picocli.CommandLine;

@CommandLine.Command(description={"Update LDAP service user's password that is stored in a Java KeyStore.%n"}, mixinStandardHelpOptions=true, sortOptions=false)
class UpdateLdapPasswordTask
extends BaseCliTask {
    @CommandLine.Mixin
    private KeystoreOptions keystoreOptions;
    @CommandLine.Option(names={"-lp", "--ldap-password"}, paramLabel="<password>", description={"New LDAP password that you want to use. Provide value directly or use without value to enter securely with interactive prompt."}, arity="0..1", interactive=true)
    private String newLdapPassword;

    UpdateLdapPasswordTask(PrintWriter out, ConfigurableEnvironment environment) {
        super(out, environment);
    }

    public void execute() {
        if (StringUtil.isNullOrEmptyAfterTrim((String)this.keystoreOptions.getKeyStorePassword())) {
            throw new CliException("KeyStore password parameter is not specified. Use --key-store-password=<password> or --key-store-password without value to enter it in interactive mode.");
        }
        if (StringUtil.isNullOrEmptyAfterTrim((String)this.newLdapPassword)) {
            throw new CliException("New LDAP password parameter is not specified. Use --ldap-password=<password> or --ldap-password without value to enter it in interactive mode.");
        }
        this.verifyKeyStorePassword(this.keystoreOptions.getKeyStorePassword());
        this.updateLdapPassword(this.keystoreOptions.getKeyStorePassword(), this.newLdapPassword);
        this.printf("Successfully updated LDAP password in KeyStore '%s'.%n", new Object[]{this.keystoreOptions.getKeyStorePath()});
    }

    private void verifyKeyStorePassword(String ksPassword) {
        String loadedPassword;
        try {
            loadedPassword = KeystoreUtil.load((String)this.keystoreOptions.getKeyStorePath(), (String)ksPassword, (String)this.keystoreOptions.getKeyStoreType(), (String)this.keystoreOptions.getKeyStoreProvider());
        }
        catch (Exception e) {
            throw new CliException("Path or password for KeyStore is wrong.", (Throwable)e);
        }
        if (StringUtil.isNullOrEmptyAfterTrim((String)loadedPassword)) {
            throw new CliException("KeyStore does not contain an entry for Management Center LDAP password.");
        }
    }

    private void updateLdapPassword(String ksPassword, String ldapPassword) {
        try {
            KeystoreUtil.store((String)this.keystoreOptions.getKeyStorePath(), (String)ksPassword, (String)ldapPassword, (String)this.keystoreOptions.getKeyStoreType(), (String)this.keystoreOptions.getKeyStoreProvider());
        }
        catch (Exception e) {
            throw new CliException("Failed to update LDAP password in KeyStore.", (Throwable)e);
        }
    }
}

