/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.cli;

import com.hazelcast.webmonitor.cli.CliException;
import com.hazelcast.webmonitor.cli.KeystoreOptions;
import com.hazelcast.webmonitor.utils.StringUtil;
import picocli.CommandLine;

class SetupKeystoreOptions {
    @CommandLine.Option(names={"-ksc", "--key-store-create"}, description={"Create a keystore if not exists. If enabled, default KeyStore type, and KeyStore provider will be used."})
    private boolean createKeyStore;
    @CommandLine.Mixin
    private KeystoreOptions keystoreOptions;

    SetupKeystoreOptions() {
    }

    boolean isEnabled() {
        return this.keystoreOptions.getKeyStorePath() != null;
    }

    void validate() {
        if (StringUtil.isNullOrEmptyAfterTrim((String)this.keystoreOptions.getKeyStorePassword())) {
            throw new CliException("KeyStore password parameter is not specified. Use --key-store-password=<password> or --key-store-password without value to enter it with interactive prompt.");
        }
        if (this.createKeyStore && this.keystoreTypeOrProviderOptionUsed()) {
            throw new CliException("When --key-store-create option is enabled, default Keystore type and provider will be used. It should not be use d with --key-store-type or --key-store-provider options");
        }
    }

    private boolean keystoreTypeOrProviderOptionUsed() {
        return !"JCEKS".equals(this.keystoreOptions.getKeyStoreType()) || !StringUtil.isNullOrEmptyAfterTrim((String)this.keystoreOptions.getKeyStoreProvider());
    }

    boolean isCreateKeyStore() {
        return this.createKeyStore;
    }

    String getKeyStorePassword() {
        return this.keystoreOptions.getKeyStorePassword();
    }

    String getKeyStorePath() {
        return this.keystoreOptions.getKeyStorePath();
    }

    String getKeyStoreType() {
        return this.keystoreOptions.getKeyStoreType();
    }

    String getKeyStoreProvider() {
        return this.keystoreOptions.getKeyStoreProvider();
    }
}

