/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.cli;

import com.hazelcast.webmonitor.cli.BaseUserTask;
import com.hazelcast.webmonitor.cli.CliException;
import com.hazelcast.webmonitor.repositories.sql.AuthTokenDAO;
import com.hazelcast.webmonitor.service.AuthTokenManager;
import java.io.PrintWriter;
import org.springframework.core.env.ConfigurableEnvironment;
import picocli.CommandLine;

@CommandLine.Command(description={"Revoke all auth tokens for the given user.%n*Important notice* Make sure that Management Center web application is stopped (offline) before starting this task.%n"}, mixinStandardHelpOptions=true, sortOptions=false)
class RevokeTokensTask
extends BaseUserTask {
    @CommandLine.Option(names={"-n", "--username"}, required=true, paramLabel="<username>")
    private String username;

    RevokeTokensTask(PrintWriter out, ConfigurableEnvironment environment) {
        super(out, environment);
    }

    public void execute() {
        try {
            AuthTokenManager authTokenManager = new AuthTokenManager(new AuthTokenDAO(this.initJdbi()));
            int revokedTokens = authTokenManager.revokeAll(this.username);
            if (revokedTokens == 0) {
                this.printf("User '%s' has no tokens.", new Object[]{this.username});
            } else {
                this.auditService.log(this.logBuilder("MC-2005 [Auth]", "Revoked all auth tokens for user").parameter("targetUser", (Object)this.username).build());
                this.printf("Successfully revoked %d %s for user '%s'.%n", new Object[]{revokedTokens, revokedTokens == 1 ? "token" : "tokens", this.username});
            }
        }
        catch (Exception e) {
            throw new CliException(String.format("Could not revoke user tokens. Reason:%n%s", e.getMessage()), (Throwable)e);
        }
    }
}

