/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.cli;

import com.hazelcast.webmonitor.cli.BaseUserTask;
import com.hazelcast.webmonitor.cli.CliException;
import com.hazelcast.webmonitor.cli.EntityAlreadyExistsException;
import com.hazelcast.webmonitor.security.spi.impl.builtin.DefaultSecurityProvider;
import com.hazelcast.webmonitor.utils.StringUtil;
import java.io.PrintWriter;
import java.util.Optional;
import java.util.stream.Stream;
import org.springframework.core.env.ConfigurableEnvironment;
import picocli.CommandLine;

@CommandLine.Command(description={"Create a new user record in the default security provider.%n*Important notice* Make sure that Management Center web application is stopped (offline) before starting this command.%n"}, mixinStandardHelpOptions=true, sortOptions=false)
class CreateUserTask
extends BaseUserTask {
    @CommandLine.Option(names={"-n", "--username"}, required=true, paramLabel="<username>", description={"Username for the user record."})
    private String username;
    @CommandLine.Option(names={"-p", "--password"}, paramLabel="<password>", description={"Password for the user record. Provide value directly or use without value to enter securely with interactive prompt.If you're on Linux or MacOS devices and provide value directly to `mc-conf`, please enclose password in single quotes like: -p='mysecr3tp@s$word'"}, arity="0..1", interactive=true)
    private String password;
    @CommandLine.Option(names={"-r", "--role"}, required=true, paramLabel="<role>", description={"Roles for the user record. Valid values: readonly, readwrite, metricsonly, admin."})
    private BaseUserTask.UserRole role;

    CreateUserTask(PrintWriter out, ConfigurableEnvironment environment) {
        super(out, environment);
    }

    public void execute() {
        DefaultSecurityProvider securityProvider;
        Optional user;
        if (StringUtil.isNullOrEmptyAfterTrim((String)this.password)) {
            throw new CliException("Password parameter is not specified. Use --password=<password> or --password without value to enter it with interactive prompt.");
        }
        if (Stream.of(this.username, this.password).anyMatch(StringUtil::containsTrailingOrLeadingWhitespace)) {
            this.printf("WARNING: The username or password contains leading or trailing spaces. Please verify and remove any unnecessary spaces from the configuration.", new Object[0]);
        }
        if ((user = (securityProvider = this.initDefaultSecurityProvider(true)).getUser(this.username)).isPresent()) {
            throw new EntityAlreadyExistsException("The user with username '%s' already exists.", this.username);
        }
        this.createUser(securityProvider, this.password);
        this.printf("Successfully created user '%s' with '%s' role.%n", new Object[]{this.username, this.role});
    }

    private void createUser(DefaultSecurityProvider securityProvider, String password) {
        try {
            securityProvider.createUser(this.username, password, this.role.internalName);
        }
        catch (Exception e) {
            throw new CliException(String.format("Could not save user. Reason:%n%s", e.getMessage()), (Throwable)e);
        }
    }
}

