CREATE TABLE IF NOT EXISTS client_bw_lists (
    id INT PRIMARY KEY AUTO_INCREMENT,
    cluster VARCHAR(255) NOT NULL,
    name VARCHAR(255),
    deployed BOOLEAN NOT NULL,
    status VARCHAR(255) NOT NULL,
    type VARCHAR(255) NOT NULL,
    -- synthetic column: equal to "cluster" if deployed, null - else
    -- this constraint is required to restrict a single deployed record per cluster
    deployed_key VARCHAR(255) UNIQUE
);

CREATE INDEX IF NOT EXISTS client_bw_lists_cluster_indx ON client_bw_lists (cluster, deployed);

CREATE TABLE IF NOT EXISTS client_bw_list_entries (
    id INT PRIMARY KEY AUTO_INCREMENT,
    list_id INT NOT NULL,
    type VARCHAR(255) NOT NULL,
    value VARCHAR(255) NOT NULL,
    FOREIGN KEY (list_id) REFERENCES client_bw_lists (id)
);
