/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.websocket;

import com.hazelcast.webmonitor.notify.Note;
import com.hazelcast.webmonitor.notify.Notifier;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.springframework.core.log.LogFormatUtils;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.socket.server.support.DefaultHandshakeHandler;

public class NotifyingHandshakeHandler
extends DefaultHandshakeHandler {
    private final Notifier notifier;

    protected void handleInvalidUpgradeHeader(ServerHttpRequest request, ServerHttpResponse response) throws IOException {
        super.handleInvalidUpgradeHeader(request, response);
        String msg = LogFormatUtils.formatValue((Object)("Handshake failed due to invalid Upgrade header: " + request.getHeaders().getUpgrade()), (int)-1, (boolean)true);
        this.notifier.signal(Note.Matter.WEBSOCKET_HANDSHAKE_FAILED.with(msg));
    }

    protected void handleInvalidConnectHeader(ServerHttpRequest request, ServerHttpResponse response) throws IOException {
        super.handleInvalidConnectHeader(request, response);
        String msg = LogFormatUtils.formatValue((Object)("Handshake failed due to invalid Connection header: " + String.valueOf(request.getHeaders().getConnection())), (int)-1, (boolean)true);
        this.notifier.signal(Note.Matter.WEBSOCKET_HANDSHAKE_FAILED.with(msg));
    }

    protected void handleWebSocketVersionNotSupported(ServerHttpRequest request, ServerHttpResponse response) {
        super.handleWebSocketVersionNotSupported(request, response);
        String version = request.getHeaders().getFirst("Sec-WebSocket-Version");
        String msg = LogFormatUtils.formatValue((Object)("Handshake failed due to unsupported WebSocket version: " + version + ". Supported versions: " + Arrays.toString(this.getSupportedVersions())), (int)-1, (boolean)true);
        this.notifier.signal(Note.Matter.WEBSOCKET_HANDSHAKE_FAILED.with(msg));
    }

    @ConstructorProperties(value={"notifier"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public NotifyingHandshakeHandler(Notifier notifier) {
        this.notifier = notifier;
    }
}

