/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.utils;

import com.hazelcast.internal.config.DomConfigHelper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * Exception performing whole class analysis ignored.
 */
public final class XmlUtil {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(XmlUtil.class);
    static final List<String> UCN_RESOURCE_TYPES = List.of("jar", "class", "jars-in-zip");

    private XmlUtil() {
    }

    public static boolean isValidXPath(String xpath) {
        try {
            XPathFactory.newInstance().newXPath().compile(xpath);
            return true;
        }
        catch (XPathExpressionException e) {
            return false;
        }
    }

    public static String maskXPathExpressionsInXml(String initialXml, String mask, List<String> xpathExpressions) {
        if (CollectionUtils.isEmpty(xpathExpressions)) {
            return initialXml;
        }
        try {
            Document document = XmlUtil.getDocumentFromXmlString((String)initialXml);
            XPath xPath = XPathFactory.newInstance().newXPath();
            for (String xpathExpression : xpathExpressions) {
                try {
                    NodeList nodes = (NodeList)xPath.evaluate(xpathExpression, document, XPathConstants.NODESET);
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        Node item = nodes.item(i);
                        item.setTextContent(mask);
                    }
                }
                catch (XPathExpressionException e) {
                    log.warn("Can not evaluate XPath expression '{}'. \n {}", (Object)xpathExpression, (Object)e.getMessage());
                }
            }
            return XmlUtil.toString((Document)document);
        }
        catch (Exception e) {
            log.warn("Can not mask sensitive values in member config", (Throwable)e);
            return initialXml;
        }
    }

    public static String removeUrlNodes(String initialXml) {
        try {
            Document document = XmlUtil.getDocumentFromXmlString((String)initialXml);
            ArrayList<Node> resources = new ArrayList<Node>();
            for (Node child : DomConfigHelper.asElementIterable((NodeList)document.getElementsByTagName("url"))) {
                Node parent = child.getParentNode();
                if (!UCN_RESOURCE_TYPES.contains(parent.getNodeName())) continue;
                resources.add(parent);
            }
            for (Node resource : resources) {
                for (Node child : DomConfigHelper.asElementIterable((NodeList)resource.getChildNodes())) {
                    resource.removeChild(child);
                }
            }
            return XmlUtil.toString((Document)document);
        }
        catch (Exception e) {
            log.warn("Can not remove resource URL values in member configuration", (Throwable)e);
            return initialXml;
        }
    }

    static String toString(Document document) throws TransformerException {
        StringWriter stringWriter = new StringWriter();
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(new DOMSource(document), new StreamResult(stringWriter));
        return stringWriter.toString();
    }

    public static Document getDocumentFromXmlString(String initialXml) throws Exception {
        DocumentBuilderFactory df = DocumentBuilderFactory.newInstance();
        df.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        df.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        return df.newDocumentBuilder().parse(new InputSource(new StringReader(initialXml)));
    }
}

