/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.sql.rest;

import com.hazelcast.sql.SqlResult;
import com.hazelcast.webmonitor.service.MCClientManager;
import com.hazelcast.webmonitor.sql.SqlManager;
import com.hazelcast.webmonitor.sql.dto.DataConnectionDTO;
import com.hazelcast.webmonitor.sql.dto.DataConnectionListDTO;
import com.hazelcast.webmonitor.sql.dto.DataConnectionResourceDTO;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.validation.Valid;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/api/clusters/{cluster}/sql/dataconnections"})
@Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_CLOUD_USER"})
public class SqlDataConnectionController {
    static final String SELECT_DATA_LINKS_SQL_FMT = "SELECT name, type, options FROM information_schema.dataconnections";
    static final String CREATE_DATA_CONNECTION_SQL_FMT = "CREATE DATA CONNECTION \"%s\" TYPE \"%s\" NOT SHARED OPTIONS %s";
    static final String DROP_DATA_CONNECTION_IF_EXISTS_SQL_FMT = "DROP DATA CONNECTION IF EXISTS \"%s\"";
    static final String SHOW_RESOURCES_FOR_DATA_CONNECTION_SQL_FMT = "SHOW RESOURCES FOR \"%s\"";
    private final MCClientManager mcClientManager;
    private final SqlManager sqlManager;

    @GetMapping
    public List<DataConnectionListDTO> list(@PathVariable String cluster) {
        try (SqlResult sqlRows = this.executeSql(cluster, SELECT_DATA_LINKS_SQL_FMT);){
            List<DataConnectionListDTO> list = StreamSupport.stream(sqlRows.spliterator(), false).map(row -> {
                String connector = (String)row.getObject("type");
                String sourceType = this.sqlManager.determineSourceType((String)row.getObject("options"), connector);
                return new DataConnectionListDTO((String)row.getObject("name"), connector, sourceType);
            }).collect(Collectors.toList());
            return list;
        }
    }

    @PostMapping
    public void create(@PathVariable String cluster, @Valid @RequestBody DataConnectionDTO dataConnection) {
        String sql = String.format(CREATE_DATA_CONNECTION_SQL_FMT, dataConnection.getName(), dataConnection.getType(), dataConnection.getOptions().entrySet().stream().map(it -> String.format("'%s' = '%s'", it.getKey(), it.getValue())).collect(Collectors.joining(", ", "(", ")")));
        this.executeSql(cluster, sql).close();
    }

    @DeleteMapping(value={"/{dataConnectionName}"})
    public void drop(@PathVariable String cluster, @PathVariable String dataConnectionName) {
        this.executeSql(cluster, String.format(DROP_DATA_CONNECTION_IF_EXISTS_SQL_FMT, dataConnectionName)).close();
    }

    @GetMapping(value={"/{dataConnectionName}/resources"})
    public List<DataConnectionResourceDTO> showResources(@PathVariable String cluster, @PathVariable String dataConnectionName) {
        String sql = String.format(SHOW_RESOURCES_FOR_DATA_CONNECTION_SQL_FMT, dataConnectionName);
        try (SqlResult sqlRows = this.executeSql(cluster, sql);){
            List<DataConnectionResourceDTO> list = StreamSupport.stream(sqlRows.spliterator(), false).map(row -> new DataConnectionResourceDTO((String)row.getObject("name"), (String)row.getObject("type"))).collect(Collectors.toList());
            return list;
        }
    }

    private SqlResult executeSql(String cluster, String sql) {
        return this.mcClientManager.clientFor(cluster).getHzClient().getSql().execute(sql, new Object[0]);
    }

    @ConstructorProperties(value={"mcClientManager", "sqlManager"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SqlDataConnectionController(MCClientManager mcClientManager, SqlManager sqlManager) {
        this.mcClientManager = mcClientManager;
        this.sqlManager = sqlManager;
    }
}

