/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.sql;

import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.json.Json;
import com.hazelcast.internal.json.JsonValue;
import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.jet.impl.JobAndSqlSummary;
import com.hazelcast.sql.HazelcastSqlException;
import com.hazelcast.sql.SqlColumnMetadata;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.sql.SqlStatement;
import com.hazelcast.sql.impl.client.SqlClientResult;
import com.hazelcast.webmonitor.controller.dto.SqlQueryDTO;
import com.hazelcast.webmonitor.controller.exception.NoResourceApiException;
import com.hazelcast.webmonitor.controller.exception.OperationFailedApiException;
import com.hazelcast.webmonitor.model.hz.req.state.Version;
import com.hazelcast.webmonitor.service.Clock;
import com.hazelcast.webmonitor.service.ClusterManager;
import com.hazelcast.webmonitor.service.MCClientManager;
import com.hazelcast.webmonitor.service.MapManager;
import com.hazelcast.webmonitor.service.OperationDispatcher;
import com.hazelcast.webmonitor.service.StateManager;
import com.hazelcast.webmonitor.service.client.MCMapConfig;
import com.hazelcast.webmonitor.sql.Histories;
import com.hazelcast.webmonitor.sql.QueryHistoryRecord;
import com.hazelcast.webmonitor.sql.SqlExecutedEvent;
import com.hazelcast.webmonitor.sql.SqlMapBrowserService;
import com.hazelcast.webmonitor.sql.SqlRowSetProcessor;
import com.hazelcast.webmonitor.sql.SqlUsage;
import com.hazelcast.webmonitor.sql.dto.ColumnDTO;
import com.hazelcast.webmonitor.sql.dto.MappingDTO;
import com.hazelcast.webmonitor.sql.dto.QueryHistoryDTO;
import com.hazelcast.webmonitor.sql.dto.SQLTaskInfoDTO;
import com.hazelcast.webmonitor.sql.dto.SqlMapBrowseDTO;
import com.hazelcast.webmonitor.sql.dto.SqlResultDTO;
import com.hazelcast.webmonitor.sql.dto.TableDTO;
import com.hazelcast.webmonitor.sql.dto.ViewDTO;
import com.hazelcast.webmonitor.utils.StringUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SqlManager {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SqlManager.class);
    static final int HISTORY_LIMIT = 100;
    private final Clock clock;
    private final OperationDispatcher dispatcher;
    private final Histories histories;
    private final StateManager stateManager;
    private final MCClientManager clientManager;
    private final MapManager mapManager;
    private final ClusterManager clusterManager;
    private final SqlRowSetProcessor rowSetProcessor;
    private final ApplicationEventPublisher applicationEventPublisher;
    private final SqlMapBrowserService mapBrowserService;
    private static final Version HAZELCAST_5_2 = Version.of((String)"5.2");
    private static final long RUNNING_TASK_THRESHOLD = 3000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SqlResultDTO execute(String username, String cluster, SqlQueryDTO query) {
        OffsetDateTime executionTime = this.clock.currentOffsetDateTime();
        String sql = query.getSql();
        QueryHistoryRecord.Status status = QueryHistoryRecord.Status.FAILURE;
        SqlClientResult sqlResult = null;
        try {
            SqlResultDTO result;
            Object columns;
            sqlResult = this.execute(cluster, sql, new String[0]);
            String queryId = UuidUtil.newUnsecureUuidString();
            if (sqlResult.isRowSet()) {
                columns = sqlResult.getRowMetadata().getColumns().stream().map(SqlColumnMetadata::getName).collect(Collectors.toList());
                this.rowSetProcessor.addPendingTask(queryId, username, sqlResult);
                result = SqlResultDTO.rowSet((String)queryId, (List)columns, (Boolean)sqlResult.isInfiniteRows(), (SqlMapBrowseDTO)this.getMapBrowserInfo(cluster, query, (List)columns));
            } else {
                result = SqlResultDTO.update((String)queryId, (long)sqlResult.updateCount());
            }
            status = QueryHistoryRecord.Status.SUCCESS;
            columns = result;
            return columns;
        }
        catch (HazelcastSqlException e) {
            SqlResultDTO sqlResultDTO = SqlResultDTO.errorWithSuggestion((String)e.getMessage(), (String)e.getSuggestion());
            return sqlResultDTO;
        }
        catch (Exception e) {
            SqlResultDTO sqlResultDTO = SqlResultDTO.error((String)e.getMessage());
            return sqlResultDTO;
        }
        finally {
            boolean isStreamingQuery = Optional.ofNullable(sqlResult).map(SqlClientResult::isInfiniteRows).orElse(false);
            SqlUsage sqlUsage = new SqlUsage(status, isStreamingQuery);
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new SqlExecutedEvent(sqlUsage));
            QueryHistoryRecord historyRecord = new QueryHistoryRecord();
            historyRecord.setSqlString(sql);
            historyRecord.setStatus(status);
            historyRecord.setExecutionTime(executionTime);
            historyRecord.setUsername(username);
            historyRecord.setCluster(cluster);
            try {
                this.histories.save(historyRecord, 100);
            }
            catch (Exception e) {
                log.error("Error while saving query history {}", (Object)historyRecord, (Object)e);
            }
        }
    }

    public void pauseStreamingQuery(String queryId) {
        this.rowSetProcessor.pauseQuery(queryId);
    }

    public void resumeStreamingQuery(String queryId) {
        this.rowSetProcessor.resumeQuery(queryId);
    }

    private SqlMapBrowseDTO getMapBrowserInfo(String cluster, SqlQueryDTO query, List<String> columns) {
        block4: {
            Optional tableName = this.mapBrowserService.parseTableName(query.getSql());
            if (tableName.isPresent()) {
                try {
                    TableDTO table = this.getTable(cluster, (String)tableName.get());
                    if (table.getType() == TableDTO.Type.MAPPING) {
                        MappingDTO mapping = this.getMapping(cluster, table.getName());
                        return this.mapBrowserService.getMapBrowseInfo(mapping, query.getSql(), columns);
                    }
                }
                catch (Exception e) {
                    if (((String)tableName.get()).startsWith("information_schema.")) break block4;
                    log.warn("Can't get Map Browser from SQL information ", (Throwable)e);
                }
            }
        }
        return SqlMapBrowseDTO.notAllowed();
    }

    public List<MappingDTO> getMappings(String cluster) {
        return this.getEntitiesList(cluster, "SELECT table_name, mapping_external_name, mapping_type, mapping_options FROM information_schema.mappings", "Can't get SQL mappings", arg_0 -> this.rowToMapping(arg_0));
    }

    public List<ViewDTO> getViews(String cluster) {
        return this.getEntitiesList(cluster, "SELECT table_name, is_updatable, insertable_into FROM information_schema.views", "Can't get SQL views", arg_0 -> this.rowToView(arg_0));
    }

    public List<ColumnDTO> getTableColumns(String cluster, String tableName) {
        String query = String.format("SELECT column_name, column_external_name, ordinal_position, is_nullable, data_type FROM information_schema.columns WHERE table_name='%s'", StringUtil.duplicateSingleQuotes((String)tableName));
        return this.getEntitiesList(cluster, query, "Can't get columns for " + tableName, arg_0 -> this.rowToColumn(arg_0));
    }

    public MappingDTO getMapping(String cluster, String mappingName) {
        String query = "SELECT table_name, mapping_type, mapping_external_name, mapping_options FROM information_schema.mappings WHERE table_name=?";
        return (MappingDTO)this.getTableEntity(cluster, query, mappingName, arg_0 -> this.rowToMapping(arg_0));
    }

    public TableDTO getTable(String cluster, String tableName) {
        String query = "SELECT table_name, table_type, is_insertable_into FROM information_schema.tables WHERE table_name=?";
        return (TableDTO)this.getTableEntity(cluster, query, tableName, arg_0 -> this.rowToTable(arg_0));
    }

    private ColumnDTO rowToColumn(SqlRow row) {
        return ColumnDTO.builder().name((String)row.getObject("column_name")).externalName((String)row.getObject("column_external_name")).ordinal(((Integer)row.getObject("ordinal_position")).intValue()).nullable(Boolean.parseBoolean((String)row.getObject("is_nullable"))).type((String)row.getObject("data_type")).build();
    }

    public String getCreateMappingSuggestionForIMap(String cluster, String iMapName) {
        HazelcastInstance hzClient = this.dispatcher.getHZClient(cluster);
        List dataMembers = hzClient.getCluster().getMembers().stream().filter(member -> !member.isLiteMember()).collect(Collectors.toList());
        if (dataMembers.isEmpty()) {
            throw new OperationFailedApiException(this.suggestionErrorMessage(cluster, iMapName, "There are no data members in the cluster."));
        }
        if (hzClient.getMap(iMapName).isEmpty()) {
            throw new OperationFailedApiException(this.suggestionErrorMessage(cluster, iMapName, "The provided map is empty."));
        }
        return (String)this.dispatcher.executeOnMembersSequentiallyUntilFirstResult(cluster, dataMembers, (mcClient, member) -> mcClient.getSqlDdlMapping(member, iMapName), e -> this.suggestionErrorMessage(cluster, iMapName)).orElseThrow(() -> {
            String clusterVersion;
            MCMapConfig mapConfig = this.mapManager.getMapConfig(cluster, iMapName);
            if (this.isNativeMapWithoutIndexes(mapConfig, clusterVersion = this.clusterManager.clusterVersion(cluster))) {
                return new OperationFailedApiException(this.suggestionErrorMessage(cluster, iMapName, "Can't provide mapping for a map with NATIVE storage format without indexes for Hazelcast Cluster version 5.2 and below. Updating the Hazelcast Cluster version to 5.3 will fix the problem."));
            }
            return new OperationFailedApiException(this.suggestionErrorMessage(cluster, iMapName));
        });
    }

    public String determineSourceType(String options, String connector) {
        JsonValue jsonValue;
        if ("jdbc".equalsIgnoreCase(connector) && options != null && (jsonValue = Json.parse((String)options.toLowerCase())).isObject()) {
            String jdbcUrl = jsonValue.asObject().getString("jdbcurl", "");
            if (jdbcUrl.startsWith("jdbc:postgresql")) {
                return "postgresql";
            }
            if (jdbcUrl.startsWith("jdbc:mysql")) {
                return "mysql";
            }
        }
        return connector;
    }

    private String suggestionErrorMessage(String cluster, String iMapName, String reason) {
        return String.format("Failed to get SQL DDL mapping for map %s on cluster %s. %s", iMapName, cluster, reason);
    }

    private String suggestionErrorMessage(String cluster, String iMapName) {
        return this.suggestionErrorMessage(cluster, iMapName, "");
    }

    private SqlClientResult execute(String cluster, String query, String ... queryParams) {
        log.debug("SQL query: [{}]", (Object)query);
        this.stateManager.verifyDataAccessEnabled(cluster);
        SqlStatement sqlStatement = new SqlStatement(query);
        if (queryParams != null) {
            for (String queryParam : queryParams) {
                sqlStatement.addParameter((Object)queryParam);
            }
        }
        return (SqlClientResult)this.dispatcher.getHZClient(cluster).getSql().execute(sqlStatement);
    }

    public List<QueryHistoryDTO> history(String username, String cluster) {
        return this.histories.findBy(username, cluster).stream().map(QueryHistoryRecord::toDto).collect(Collectors.toList());
    }

    private <T> List<T> getEntitiesList(String cluster, String query, String errorMessage, Function<SqlRow, T> conversion) {
        List list;
        block8: {
            SqlClientResult sqlResult = this.execute(cluster, query, new String[0]);
            try {
                list = StreamSupport.stream(sqlResult.spliterator(), false).map(conversion).collect(Collectors.toList());
                if (sqlResult == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (sqlResult != null) {
                        try {
                            sqlResult.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.warn(errorMessage, (Throwable)e);
                    return Collections.emptyList();
                }
            }
            sqlResult.close();
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T getTableEntity(String cluster, String query, String tableName, Function<SqlRow, T> conversion) {
        try (SqlClientResult sqlResult = this.execute(cluster, query, new String[]{tableName});){
            Iterator iterator = sqlResult.iterator();
            if (!iterator.hasNext()) throw new NoResourceApiException(tableName);
            SqlRow row = (SqlRow)iterator.next();
            SqlRow sqlRow = conversion.apply(row);
            return (T)sqlRow;
        }
        catch (Exception e) {
            String message = String.format("Can't get SQL table '%s'.", tableName);
            throw new OperationFailedApiException(message, (Throwable)e);
        }
    }

    private MappingDTO rowToMapping(SqlRow row) {
        String mappingType = (String)row.getObject("mapping_type");
        String mappingExternalName = (String)row.getObject("mapping_external_name");
        return MappingDTO.builder().name((String)row.getObject("table_name")).type(mappingType).externalName("IMAP".equalsIgnoreCase(mappingType) ? StringUtil.unwrapDoubleQuotes((String)mappingExternalName) : mappingExternalName).options((String)row.getObject("mapping_options")).build();
    }

    private ViewDTO rowToView(SqlRow row) {
        return ViewDTO.builder().name((String)row.getObject("table_name")).updatable(Boolean.parseBoolean((String)row.getObject("is_updatable"))).insertable(Boolean.parseBoolean((String)row.getObject("insertable_into"))).build();
    }

    private TableDTO rowToTable(SqlRow row) {
        String rawTableType = (String)row.getObject("table_type");
        TableDTO.Type type = TableDTO.Type.fromPlatformTableType((String)rawTableType);
        return TableDTO.builder().name((String)row.getObject("table_name")).type(type).insertableInto(Boolean.parseBoolean((String)row.getObject("is_insertable_into"))).build();
    }

    private boolean isNativeMapWithoutIndexes(MCMapConfig mapConfig, String clusterVersion) {
        return mapConfig.getInMemoryFormat() == InMemoryFormat.NATIVE && CollectionUtils.isEmpty((Collection)mapConfig.getGlobalIndexes()) && clusterVersion != null && Version.of((String)clusterVersion).isLessOrEqual(HAZELCAST_5_2);
    }

    public List<SQLTaskInfoDTO> getSqlTasks(String cluster) {
        return this.clientManager.clientFor(cluster).getJobSummaryList().stream().filter(JobAndSqlSummary::isLightJob).filter(t -> t.getSqlSummary() != null).filter(t -> this.clock.currentTimeMillis() - t.getSubmissionTime() > 3000L).map(arg_0 -> this.toSqlTaskInfo(arg_0)).collect(Collectors.toList());
    }

    private SQLTaskInfoDTO toSqlTaskInfo(JobAndSqlSummary summary) {
        return SQLTaskInfoDTO.builder().jobId(summary.getJobId()).nameOrId(summary.getNameOrId()).executionId(summary.getExecutionId()).isUnbounded(summary.getSqlSummary().isUnbounded()).query(summary.getSqlSummary().getQuery()).status(summary.getStatus()).submissionTime(summary.getSubmissionTime()).build();
    }

    @ConstructorProperties(value={"clock", "dispatcher", "histories", "stateManager", "clientManager", "mapManager", "clusterManager", "rowSetProcessor", "applicationEventPublisher", "mapBrowserService"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SqlManager(Clock clock, OperationDispatcher dispatcher, Histories histories, StateManager stateManager, MCClientManager clientManager, MapManager mapManager, ClusterManager clusterManager, SqlRowSetProcessor rowSetProcessor, ApplicationEventPublisher applicationEventPublisher, SqlMapBrowserService mapBrowserService) {
        this.clock = clock;
        this.dispatcher = dispatcher;
        this.histories = histories;
        this.stateManager = stateManager;
        this.clientManager = clientManager;
        this.mapManager = mapManager;
        this.clusterManager = clusterManager;
        this.rowSetProcessor = rowSetProcessor;
        this.applicationEventPublisher = applicationEventPublisher;
        this.mapBrowserService = mapBrowserService;
    }
}

