/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.session;

import com.hazelcast.webmonitor.config.properties.MCConfigurationProperties;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Objects;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.session.SessionInformation;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.web.authentication.session.ConcurrentSessionControlAuthenticationStrategy;

public class SessionControlAuthenticationStrategy
extends ConcurrentSessionControlAuthenticationStrategy {
    static final String INVALIDATE_OTHER_SESSIONS_KEY = "invalidate-other-sessions";
    private final SessionRegistry sessionRegistry;
    private final MCConfigurationProperties mcProperties;

    public SessionControlAuthenticationStrategy(SessionRegistry sessionRegistry, MCConfigurationProperties mcProperties) {
        super(sessionRegistry);
        this.sessionRegistry = sessionRegistry;
        this.mcProperties = mcProperties;
        this.setMaximumSessions(!mcProperties.isAllowMultipleLogin() ? 1 : -1);
        this.setExceptionIfMaximumExceeded(!mcProperties.isForceLogoutOnMultipleLogin());
    }

    public void onAuthentication(Authentication authentication, HttpServletRequest request, HttpServletResponse response) {
        if (!this.mcProperties.isAllowMultipleLogin() && Boolean.parseBoolean(request.getParameter(INVALIDATE_OTHER_SESSIONS_KEY))) {
            String currentSessionId = request.getSession().getId();
            List activeSessionsForUser = this.sessionRegistry.getAllSessions(authentication.getPrincipal(), false);
            activeSessionsForUser.stream().filter(sessionInfo -> !Objects.equals(sessionInfo.getSessionId(), currentSessionId)).forEach(SessionInformation::expireNow);
        }
        super.onAuthentication(authentication, request, response);
    }
}

